/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.Resource;

public class ContextLoader
implements ApplicationContextAware {
    protected static Logger log = LoggerFactory.getLogger(ContextLoader.class);
    protected ApplicationContext applicationContext;
    protected ApplicationContext parentContext;
    protected String contextsConfig;
    protected HashMap<String, ApplicationContext> contextMap = new HashMap();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    public void setContextsConfig(String contextsConfig) {
        this.contextsConfig = contextsConfig;
    }

    public void init() throws Exception {
        Properties props = new Properties();
        Resource res = this.applicationContext.getResource(this.contextsConfig);
        if (!res.exists()) {
            log.error("Contexts config must be set.");
            return;
        }
        props.load(res.getInputStream());
        for (Object key : props.keySet()) {
            String name = (String)key;
            String config = props.getProperty(name);
            config = config.replace("${red5.root}", System.getProperty("red5.root"));
            config = config.replace("${red5.config_root}", System.getProperty("red5.config_root"));
            log.info("Loading: " + name + " = " + config);
            this.loadContext(name, config);
        }
    }

    protected void loadContext(String name, String config) {
        log.debug("Load context - name: " + name + " config: " + config);
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(new String[]{config}, this.parentContext);
        this.contextMap.put(name, (ApplicationContext)context);
        ConfigurableListableBeanFactory factory = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        factory.registerSingleton(name, (Object)context);
    }

    public ApplicationContext getContext(String name) {
        return this.contextMap.get(name);
    }
}

