/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.util.ExpiringStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugPooledByteBufferAllocator
implements ByteBufferAllocator {
    protected static Logger log = LoggerFactory.getLogger(DebugPooledByteBufferAllocator.class);
    protected static ThreadLocal local = new ThreadLocal();
    protected HashMap<UnexpandableByteBuffer, StackTraceElement[]> stacks = new HashMap();
    protected boolean saveStacks;
    private static final int MINIMUM_CAPACITY = 1;
    private static int threadId;
    private int count;
    private final Expirer expirer;
    private final ExpiringStack containerStack = new ExpiringStack();
    private final ExpiringStack[] heapBufferStacks = new ExpiringStack[]{new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack()};
    private final ExpiringStack[] directBufferStacks = new ExpiringStack[]{new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack(), new ExpiringStack()};
    private int timeout;
    private boolean disposed;

    public static void setCodeSection(String section) {
        local.set(section);
    }

    public static String getCodeSection() {
        return local.get() == null ? "unknown" : (String)local.get();
    }

    public DebugPooledByteBufferAllocator() {
        this(60, false);
    }

    public DebugPooledByteBufferAllocator(boolean saveStacks) {
        this(60, saveStacks);
    }

    public DebugPooledByteBufferAllocator(int timeout) {
        this(timeout, false);
    }

    public DebugPooledByteBufferAllocator(int timeout, boolean saveStacks) {
        this.saveStacks = saveStacks;
        this.setTimeout(timeout);
        this.expirer = new Expirer();
        this.expirer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ExpiringStack expiringStack;
        ExpiringStack stack;
        int i;
        if (this == ByteBuffer.getAllocator()) {
            throw new IllegalStateException("This allocator is in use.");
        }
        this.expirer.shutdown();
        ExpiringStack expiringStack2 = this.containerStack;
        synchronized (expiringStack2) {
            this.containerStack.clear();
        }
        for (i = this.directBufferStacks.length - 1; i >= 0; --i) {
            expiringStack = stack = this.directBufferStacks[i];
            synchronized (expiringStack) {
                stack.clear();
                continue;
            }
        }
        for (i = this.heapBufferStacks.length - 1; i >= 0; --i) {
            expiringStack = stack = this.heapBufferStacks[i];
            synchronized (expiringStack) {
                stack.clear();
                continue;
            }
        }
        this.disposed = true;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getTimeoutMillis() {
        return (long)this.timeout * 1000L;
    }

    public void setTimeout(int timeout) {
        if (timeout < 0) {
            timeout = 0;
        }
        this.timeout = timeout;
    }

    public ByteBuffer allocate(int capacity, boolean direct) {
        this.ensureNotDisposed();
        UnexpandableByteBuffer ubb = this.allocate0(capacity, direct);
        PooledByteBuffer buf = this.allocateContainer();
        buf.init(ubb, true);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledByteBuffer allocateContainer() {
        PooledByteBuffer buf;
        ExpiringStack expiringStack = this.containerStack;
        synchronized (expiringStack) {
            buf = (PooledByteBuffer)((Object)this.containerStack.pop());
        }
        if (buf == null) {
            buf = new PooledByteBuffer();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStacks() {
        HashMap<UnexpandableByteBuffer, StackTraceElement[]> hashMap = this.stacks;
        synchronized (hashMap) {
            this.stacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStacks() {
        HashMap<UnexpandableByteBuffer, StackTraceElement[]> hashMap = this.stacks;
        synchronized (hashMap) {
            for (Map.Entry<UnexpandableByteBuffer, StackTraceElement[]> entry : this.stacks.entrySet()) {
                StackTraceElement[] stack;
                System.err.println("Stack for buffer " + entry.getKey());
                for (StackTraceElement element : stack = entry.getValue()) {
                    System.err.println("  " + element);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnexpandableByteBuffer allocate0(int capacity, boolean direct) {
        UnexpandableByteBuffer buf;
        ExpiringStack stack;
        ++this.count;
        ExpiringStack[] bufferStacks = direct ? this.directBufferStacks : this.heapBufferStacks;
        int idx = this.getBufferStackIndex(bufferStacks, capacity);
        Object object = stack = bufferStacks[idx];
        synchronized (object) {
            buf = (UnexpandableByteBuffer)stack.pop();
        }
        if (buf == null) {
            java.nio.ByteBuffer nioBuf = direct ? java.nio.ByteBuffer.allocateDirect(1 << idx) : java.nio.ByteBuffer.allocate(1 << idx);
            buf = new UnexpandableByteBuffer(nioBuf);
        }
        buf.init();
        log.info("+++ " + this.count + " (" + buf.buf().capacity() + ") " + DebugPooledByteBufferAllocator.getCodeSection() + " req: " + capacity);
        if (this.saveStacks) {
            object = this.stacks;
            synchronized (object) {
                this.stacks.put(buf, Thread.currentThread().getStackTrace());
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release0(UnexpandableByteBuffer buf) {
        ExpiringStack stack;
        --this.count;
        log.info("--- " + this.count + " (" + buf.buf().capacity() + ") " + DebugPooledByteBufferAllocator.getCodeSection());
        if (this.saveStacks) {
            HashMap<UnexpandableByteBuffer, StackTraceElement[]> hashMap = this.stacks;
            synchronized (hashMap) {
                this.stacks.remove(buf);
            }
        }
        ExpiringStack[] bufferStacks = buf.buf().isDirect() ? this.directBufferStacks : this.heapBufferStacks;
        ExpiringStack expiringStack = stack = bufferStacks[this.getBufferStackIndex(bufferStacks, buf.buf().capacity())];
        synchronized (expiringStack) {
            stack.push((Object)buf);
        }
    }

    public ByteBuffer wrap(java.nio.ByteBuffer nioBuffer) {
        this.ensureNotDisposed();
        PooledByteBuffer buf = this.allocateContainer();
        buf.init(new UnexpandableByteBuffer(nioBuffer), false);
        buf.buf.init();
        buf.setPooled(false);
        return buf;
    }

    private int getBufferStackIndex(ExpiringStack[] bufferStacks, int size) {
        int stackIdx = 0;
        for (int targetSize = 1; size > targetSize; targetSize <<= 1) {
            if (++stackIdx < bufferStacks.length) continue;
            throw new IllegalArgumentException("Buffer size is too big: " + size);
        }
        return stackIdx;
    }

    private void ensureNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("This allocator is disposed already.");
        }
    }

    private class UnexpandableByteBuffer {
        private final java.nio.ByteBuffer buf;
        private final UnexpandableByteBuffer parentBuf;
        private int refCount;
        private boolean pooled;

        protected UnexpandableByteBuffer(java.nio.ByteBuffer buf) {
            this.buf = buf;
            this.parentBuf = null;
        }

        protected UnexpandableByteBuffer(java.nio.ByteBuffer buf, UnexpandableByteBuffer parentBuf) {
            parentBuf.acquire();
            this.buf = buf;
            this.parentBuf = parentBuf;
        }

        public void init() {
            this.refCount = 1;
            this.pooled = true;
        }

        public synchronized void acquire() {
            if (this.isDerived()) {
                this.parentBuf.acquire();
                return;
            }
            if (this.refCount <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            if (this.isDerived()) {
                this.parentBuf.release();
                return;
            }
            UnexpandableByteBuffer unexpandableByteBuffer = this;
            synchronized (unexpandableByteBuffer) {
                if (this.refCount <= 0) {
                    this.refCount = 0;
                    throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
                }
                --this.refCount;
                if (this.refCount > 0) {
                    return;
                }
            }
            if (DebugPooledByteBufferAllocator.this.disposed) {
                return;
            }
            if (this.pooled) {
                if (this.parentBuf != null) {
                    DebugPooledByteBufferAllocator.this.release0(this.parentBuf);
                } else {
                    DebugPooledByteBufferAllocator.this.release0(this);
                }
            }
        }

        public java.nio.ByteBuffer buf() {
            return this.buf;
        }

        public boolean isPooled() {
            return this.pooled;
        }

        public void setPooled(boolean pooled) {
            this.pooled = pooled;
        }

        public boolean isDerived() {
            return this.parentBuf != null;
        }
    }

    private class PooledByteBuffer
    extends ByteBuffer {
        private UnexpandableByteBuffer buf;
        private int refCount = 1;
        private boolean autoExpand;

        protected PooledByteBuffer() {
        }

        public synchronized void init(UnexpandableByteBuffer buf, boolean clear) {
            this.buf = buf;
            if (clear) {
                buf.buf().clear();
            }
            buf.buf().order(ByteOrder.BIG_ENDIAN);
            this.autoExpand = false;
            this.refCount = 1;
        }

        public synchronized void acquire() {
            if (this.refCount <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            PooledByteBuffer pooledByteBuffer = this;
            synchronized (pooledByteBuffer) {
                if (this.refCount <= 0) {
                    this.refCount = 0;
                    throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
                }
                --this.refCount;
                if (this.refCount > 0) {
                    return;
                }
            }
            if (DebugPooledByteBufferAllocator.this.disposed) {
                return;
            }
            this.buf.release();
            pooledByteBuffer = DebugPooledByteBufferAllocator.this.containerStack;
            synchronized (pooledByteBuffer) {
                DebugPooledByteBufferAllocator.this.containerStack.push((Object)this);
            }
        }

        public java.nio.ByteBuffer buf() {
            return this.buf.buf();
        }

        public boolean isDirect() {
            return this.buf.buf().isDirect();
        }

        public boolean isReadOnly() {
            return this.buf.buf().isReadOnly();
        }

        public boolean isAutoExpand() {
            return this.autoExpand;
        }

        public ByteBuffer setAutoExpand(boolean autoExpand) {
            this.autoExpand = autoExpand;
            return this;
        }

        public boolean isPooled() {
            return this.buf.isPooled();
        }

        public void setPooled(boolean pooled) {
            this.buf.setPooled(pooled);
        }

        public int capacity() {
            return this.buf.buf().capacity();
        }

        public int position() {
            return this.buf.buf().position();
        }

        public ByteBuffer position(int newPosition) {
            this.autoExpand(newPosition, 0);
            this.buf.buf().position(newPosition);
            return this;
        }

        public int limit() {
            return this.buf.buf().limit();
        }

        public ByteBuffer limit(int newLimit) {
            this.autoExpand(newLimit, 0);
            this.buf.buf().limit(newLimit);
            return this;
        }

        public ByteBuffer mark() {
            this.buf.buf().mark();
            return this;
        }

        public ByteBuffer reset() {
            this.buf.buf().reset();
            return this;
        }

        public ByteBuffer clear() {
            this.buf.buf().clear();
            return this;
        }

        public ByteBuffer flip() {
            this.buf.buf().flip();
            return this;
        }

        public ByteBuffer rewind() {
            this.buf.buf().rewind();
            return this;
        }

        public int remaining() {
            return this.buf.buf().remaining();
        }

        public ByteBuffer duplicate() {
            PooledByteBuffer newBuf = DebugPooledByteBufferAllocator.this.allocateContainer();
            newBuf.init(new UnexpandableByteBuffer(this.buf.buf().duplicate(), this.buf), false);
            return newBuf;
        }

        public ByteBuffer slice() {
            PooledByteBuffer newBuf = DebugPooledByteBufferAllocator.this.allocateContainer();
            newBuf.init(new UnexpandableByteBuffer(this.buf.buf().slice(), this.buf), false);
            return newBuf;
        }

        public ByteBuffer asReadOnlyBuffer() {
            PooledByteBuffer newBuf = DebugPooledByteBufferAllocator.this.allocateContainer();
            newBuf.init(new UnexpandableByteBuffer(this.buf.buf().asReadOnlyBuffer(), this.buf), false);
            return newBuf;
        }

        public byte get() {
            return this.buf.buf().get();
        }

        public ByteBuffer put(byte b) {
            this.autoExpand(1);
            this.buf.buf().put(b);
            return this;
        }

        public byte get(int index) {
            return this.buf.buf().get(index);
        }

        public ByteBuffer put(int index, byte b) {
            this.autoExpand(index, 1);
            this.buf.buf().put(index, b);
            return this;
        }

        public ByteBuffer get(byte[] dst, int offset, int length) {
            this.buf.buf().get(dst, offset, length);
            return this;
        }

        public ByteBuffer put(java.nio.ByteBuffer src) {
            this.autoExpand(src.remaining());
            this.buf.buf().put(src);
            return this;
        }

        public ByteBuffer put(byte[] src, int offset, int length) {
            this.autoExpand(length);
            this.buf.buf().put(src, offset, length);
            return this;
        }

        public ByteBuffer compact() {
            this.buf.buf().compact();
            return this;
        }

        public int compareTo(ByteBuffer that) {
            return this.buf.buf().compareTo(that.buf());
        }

        public ByteOrder order() {
            return this.buf.buf().order();
        }

        public ByteBuffer order(ByteOrder bo) {
            this.buf.buf().order(bo);
            return this;
        }

        public char getChar() {
            return this.buf.buf().getChar();
        }

        public ByteBuffer putChar(char value) {
            this.autoExpand(2);
            this.buf.buf().putChar(value);
            return this;
        }

        public char getChar(int index) {
            return this.buf.buf().getChar(index);
        }

        public ByteBuffer putChar(int index, char value) {
            this.autoExpand(index, 2);
            this.buf.buf().putChar(index, value);
            return this;
        }

        public CharBuffer asCharBuffer() {
            return this.buf.buf().asCharBuffer();
        }

        public short getShort() {
            return this.buf.buf().getShort();
        }

        public ByteBuffer putShort(short value) {
            this.autoExpand(2);
            this.buf.buf().putShort(value);
            return this;
        }

        public short getShort(int index) {
            return this.buf.buf().getShort(index);
        }

        public ByteBuffer putShort(int index, short value) {
            this.autoExpand(index, 2);
            this.buf.buf().putShort(index, value);
            return this;
        }

        public ShortBuffer asShortBuffer() {
            return this.buf.buf().asShortBuffer();
        }

        public int getInt() {
            return this.buf.buf().getInt();
        }

        public ByteBuffer putInt(int value) {
            this.autoExpand(4);
            this.buf.buf().putInt(value);
            return this;
        }

        public int getInt(int index) {
            return this.buf.buf().getInt(index);
        }

        public ByteBuffer putInt(int index, int value) {
            this.autoExpand(index, 4);
            this.buf.buf().putInt(index, value);
            return this;
        }

        public IntBuffer asIntBuffer() {
            return this.buf.buf().asIntBuffer();
        }

        public long getLong() {
            return this.buf.buf().getLong();
        }

        public ByteBuffer putLong(long value) {
            this.autoExpand(8);
            this.buf.buf().putLong(value);
            return this;
        }

        public long getLong(int index) {
            return this.buf.buf().getLong(index);
        }

        public ByteBuffer putLong(int index, long value) {
            this.autoExpand(index, 8);
            this.buf.buf().putLong(index, value);
            return this;
        }

        public LongBuffer asLongBuffer() {
            return this.buf.buf().asLongBuffer();
        }

        public float getFloat() {
            return this.buf.buf().getFloat();
        }

        public ByteBuffer putFloat(float value) {
            this.autoExpand(4);
            this.buf.buf().putFloat(value);
            return this;
        }

        public float getFloat(int index) {
            return this.buf.buf().getFloat(index);
        }

        public ByteBuffer putFloat(int index, float value) {
            this.autoExpand(index, 4);
            this.buf.buf().putFloat(index, value);
            return this;
        }

        public FloatBuffer asFloatBuffer() {
            return this.buf.buf().asFloatBuffer();
        }

        public double getDouble() {
            return this.buf.buf().getDouble();
        }

        public ByteBuffer putDouble(double value) {
            this.autoExpand(8);
            this.buf.buf().putDouble(value);
            return this;
        }

        public double getDouble(int index) {
            return this.buf.buf().getDouble(index);
        }

        public ByteBuffer putDouble(int index, double value) {
            this.autoExpand(index, 8);
            this.buf.buf().putDouble(index, value);
            return this;
        }

        public DoubleBuffer asDoubleBuffer() {
            return this.buf.buf().asDoubleBuffer();
        }

        public ByteBuffer expand(int expectedRemaining) {
            int limit;
            int pos;
            int end;
            if (this.autoExpand && (end = (pos = this.buf.buf().position()) + expectedRemaining) > (limit = this.buf.buf().limit())) {
                this.ensureCapacity(end);
                this.buf.buf().limit(end);
            }
            return this;
        }

        public ByteBuffer expand(int pos, int expectedRemaining) {
            int limit;
            int end;
            if (this.autoExpand && (end = pos + expectedRemaining) > (limit = this.buf.buf().limit())) {
                this.ensureCapacity(end);
                this.buf.buf().limit(end);
            }
            return this;
        }

        private void ensureCapacity(int requestedCapacity) {
            int newCapacity;
            if (requestedCapacity <= this.buf.buf().capacity()) {
                return;
            }
            if (this.buf.isDerived()) {
                throw new IllegalStateException("Derived buffers cannot be expanded.");
            }
            for (newCapacity = 1; newCapacity < requestedCapacity; newCapacity <<= 1) {
            }
            UnexpandableByteBuffer oldBuf = this.buf;
            UnexpandableByteBuffer newBuf = DebugPooledByteBufferAllocator.this.allocate0(newCapacity, this.isDirect());
            newBuf.buf().clear();
            newBuf.buf().order(oldBuf.buf().order());
            int pos = oldBuf.buf().position();
            int limit = oldBuf.buf().limit();
            oldBuf.buf().clear();
            newBuf.buf().put(oldBuf.buf());
            newBuf.buf().position(0);
            newBuf.buf().limit(limit);
            newBuf.buf().position(pos);
            this.buf = newBuf;
            oldBuf.release();
        }

        public byte[] array() {
            return null;
        }

        public int arrayOffset() {
            return 0;
        }

        public ByteBuffer capacity(int newCapacity) {
            return null;
        }

        public int markValue() {
            return 0;
        }
    }

    private class Expirer
    extends Thread {
        private boolean timeToStop;

        public Expirer() {
            super("PooledByteBufferExpirer-" + threadId++);
            this.setDaemon(true);
        }

        public void shutdown() {
            this.timeToStop = true;
            this.interrupt();
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.timeToStop) {
                ExpiringStack expiringStack;
                ExpiringStack stack;
                int i;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.debug("InterruptedEx");
                }
                long timeout = DebugPooledByteBufferAllocator.this.getTimeoutMillis();
                if (timeout <= 0L) continue;
                long expirationTime = System.currentTimeMillis() - timeout;
                ExpiringStack expiringStack2 = DebugPooledByteBufferAllocator.this.containerStack;
                synchronized (expiringStack2) {
                    DebugPooledByteBufferAllocator.this.containerStack.expireBefore(expirationTime);
                }
                for (i = DebugPooledByteBufferAllocator.this.directBufferStacks.length - 1; i >= 0; --i) {
                    expiringStack = stack = DebugPooledByteBufferAllocator.this.directBufferStacks[i];
                    synchronized (expiringStack) {
                        stack.expireBefore(expirationTime);
                        continue;
                    }
                }
                for (i = DebugPooledByteBufferAllocator.this.heapBufferStacks.length - 1; i >= 0; --i) {
                    expiringStack = stack = DebugPooledByteBufferAllocator.this.heapBufferStacks[i];
                    synchronized (expiringStack) {
                        stack.expireBefore(expirationTime);
                        continue;
                    }
                }
            }
        }
    }
}

