/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.red5.server.api.IApplicationContext;
import org.red5.server.api.IApplicationLoader;
import org.springframework.context.ApplicationContext;

public class LoaderBase {
    protected static ThreadLocal<ApplicationContext> applicationContext = new ThreadLocal();
    public static Map<String, IApplicationContext> red5AppCtx = new HashMap<String, IApplicationContext>();
    protected static ThreadLocal<IApplicationLoader> loader = new ThreadLocal();
    protected String webappFolder = null;

    public static IApplicationLoader getApplicationLoader() {
        return loader.get();
    }

    public static void setApplicationLoader(IApplicationLoader loader) {
        LoaderBase.loader.set(loader);
    }

    public static IApplicationContext getRed5ApplicationContext(String path) {
        return red5AppCtx.get(path);
    }

    public static void setRed5ApplicationContext(String path, IApplicationContext context) {
        if (context != null) {
            red5AppCtx.put(path, context);
        } else {
            red5AppCtx.remove(path);
        }
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext.get();
    }

    public void setWebappFolder(String webappFolder) {
        File fp = new File(webappFolder);
        if (!fp.isDirectory()) {
            throw new RuntimeException("Webapp folder " + webappFolder + " doesn't exist.");
        }
        this.webappFolder = webappFolder;
    }
}

