/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Input;
import org.red5.io.object.Output;
import org.red5.io.object.Serializer;
import org.red5.server.AttributeStore;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.persistence.IPersistable;
import org.red5.server.api.persistence.IPersistenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistableAttributeStore
extends AttributeStore
implements IPersistable {
    protected boolean persistent = true;
    protected String name;
    protected String type;
    protected String path;
    protected long lastModified = -1L;
    protected IPersistenceStore store;

    public PersistableAttributeStore(String type, String name, String path, boolean persistent) {
        this.type = type;
        this.name = name;
        this.path = path;
        this.persistent = persistent;
    }

    protected void modified() {
        this.lastModified = System.currentTimeMillis();
        if (this.store != null) {
            this.store.save(this);
        }
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void serialize(Output output) throws IOException {
        Serializer serializer = new Serializer();
        HashMap<String, Object> persistentAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.getAttributes().entrySet()) {
            String name = entry.getKey();
            if (name.startsWith("_transient")) continue;
            persistentAttributes.put(name, entry.getValue());
        }
        serializer.serialize(output, persistentAttributes);
    }

    @Override
    public void deserialize(Input input) throws IOException {
        Deserializer deserializer = new Deserializer();
        this.setAttributes(deserializer.deserialize(input, Map.class));
    }

    @Override
    public void setStore(IPersistenceStore store) {
        if (this.store != null) {
            this.store.notifyClose();
        }
        this.store = store;
        if (store != null) {
            store.load(this);
        }
    }

    @Override
    public IPersistenceStore getStore() {
        return this.store;
    }

    @Override
    public Object getAttribute(String name, Object defaultValue) {
        if (name == null) {
            return null;
        }
        if (defaultValue == null) {
            throw new NullPointerException("the default value may not be null");
        }
        Object result = this.attributes.putIfAbsent(name, defaultValue);
        if (result == null) {
            this.modified();
            result = defaultValue;
        }
        return result;
    }

    @Override
    public boolean setAttribute(String name, Object value) {
        boolean result = super.setAttribute(name, value);
        if (result && name != null && !name.startsWith("_transient")) {
            this.modified();
        }
        return result;
    }

    @Override
    public void setAttributes(Map<String, Object> values) {
        super.setAttributes(values);
        this.modified();
    }

    @Override
    public void setAttributes(IAttributeStore values) {
        super.setAttributes(values);
        this.modified();
    }

    @Override
    public boolean removeAttribute(String name) {
        boolean result = super.removeAttribute(name);
        if (result && name != null && !name.startsWith("_transient")) {
            this.modified();
        }
        return result;
    }

    @Override
    public void removeAttributes() {
        super.removeAttributes();
        this.modified();
    }
}

