/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import org.red5.server.WebScope;
import org.red5.server.api.IGlobalScope;
import org.red5.server.api.IScope;
import org.red5.server.api.IScopeResolver;
import org.red5.server.exception.ScopeNotFoundException;
import org.red5.server.exception.ScopeShuttingDownException;

public class ScopeResolver
implements IScopeResolver {
    public static final String DEFAULT_HOST = "";
    protected IGlobalScope globalScope;

    public IGlobalScope getGlobalScope() {
        return this.globalScope;
    }

    public void setGlobalScope(IGlobalScope root) {
        this.globalScope = root;
    }

    public IScope resolveScope(String path) {
        return this.resolveScope(this.globalScope, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScope resolveScope(IScope root, String path) {
        String[] parts;
        IScope scope = root;
        if (path == null) {
            return scope;
        }
        for (String room : parts = path.split("/")) {
            if (room.equals(DEFAULT_HOST)) continue;
            if (scope.hasChildScope(room)) {
                scope = scope.getScope(room);
            } else if (!scope.equals(root)) {
                IScope iScope = scope;
                synchronized (iScope) {
                    if (scope.hasChildScope(room)) {
                        scope = scope.getScope(room);
                    } else if (scope.createChildScope(room)) {
                        scope = scope.getScope(room);
                    } else {
                        throw new ScopeNotFoundException(scope, room);
                    }
                }
            } else {
                throw new ScopeNotFoundException(scope, room);
            }
            if (!(scope instanceof WebScope) || !((WebScope)scope).isShuttingDown()) continue;
            throw new ScopeShuttingDownException(scope);
        }
        return scope;
    }
}

