/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.red5.server.api.IConnection;
import org.red5.server.api.IGlobalScope;
import org.red5.server.api.IScope;
import org.red5.server.api.IServer;
import org.red5.server.api.listeners.IConnectionListener;
import org.red5.server.api.listeners.IScopeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IServer,
ApplicationContextAware {
    protected static Logger log = LoggerFactory.getLogger(Server.class);
    protected ConcurrentMap<String, IGlobalScope> globals = new ConcurrentHashMap<String, IGlobalScope>();
    protected ConcurrentMap<String, String> mapping = new ConcurrentHashMap<String, String>();
    protected ApplicationContext applicationContext;
    protected static final String SLASH = "/";
    protected static final String EMPTY = "";
    public Set<IScopeListener> scopeListeners = new CopyOnWriteArraySet<IScopeListener>();
    public Set<IConnectionListener> connectionListeners = new CopyOnWriteArraySet<IConnectionListener>();

    public void setApplicationContext(ApplicationContext applicationContext) {
        log.debug("Setting application context");
        this.applicationContext = applicationContext;
    }

    protected String getKey(String hostName, String contextPath) {
        if (hostName == null) {
            hostName = EMPTY;
        }
        if (contextPath == null) {
            contextPath = EMPTY;
        }
        return hostName + SLASH + contextPath;
    }

    @Override
    public IGlobalScope lookupGlobal(String hostName, String contextPath) {
        String globalName;
        log.debug("{}", (Object)this);
        String key = this.getKey(hostName, contextPath);
        while (contextPath.indexOf(SLASH) != -1) {
            key = this.getKey(hostName, contextPath);
            if (log.isDebugEnabled()) {
                log.debug("Check: " + key);
            }
            if ((globalName = (String)this.mapping.get(key)) != null) {
                return this.getGlobal(globalName);
            }
            int slashIndex = contextPath.lastIndexOf(SLASH);
            contextPath = contextPath.substring(0, slashIndex);
        }
        key = this.getKey(hostName, contextPath);
        if (log.isDebugEnabled()) {
            log.debug("Check host and path: " + key);
        }
        if ((globalName = (String)this.mapping.get(key)) != null) {
            return this.getGlobal(globalName);
        }
        key = this.getKey(EMPTY, contextPath);
        if (log.isDebugEnabled()) {
            log.debug("Check wildcard host with path: " + key);
        }
        if ((globalName = (String)this.mapping.get(key)) != null) {
            return this.getGlobal(globalName);
        }
        key = this.getKey(hostName, EMPTY);
        if (log.isDebugEnabled()) {
            log.debug("Check host with no path: " + key);
        }
        if ((globalName = (String)this.mapping.get(key)) != null) {
            return this.getGlobal(globalName);
        }
        key = this.getKey(EMPTY, EMPTY);
        if (log.isDebugEnabled()) {
            log.debug("Check default host, default path: " + key);
        }
        return this.getGlobal((String)this.mapping.get(key));
    }

    @Override
    public IGlobalScope getGlobal(String name) {
        if (name == null) {
            return null;
        }
        return (IGlobalScope)this.globals.get(name);
    }

    @Override
    public void registerGlobal(IGlobalScope scope) {
        log.info("Registering global scope: " + scope.getName());
        this.globals.put(scope.getName(), scope);
    }

    @Override
    public boolean addMapping(String hostName, String contextPath, String globalName) {
        log.info("Add mapping global: " + globalName + " host: " + hostName + " context: " + contextPath);
        String key = this.getKey(hostName, contextPath);
        if (log.isDebugEnabled()) {
            log.debug("Add mapping: " + key + " => " + globalName);
        }
        return this.mapping.putIfAbsent(key, globalName) == null;
    }

    @Override
    public boolean removeMapping(String hostName, String contextPath) {
        log.info("Remove mapping host: " + hostName + " context: " + contextPath);
        String key = this.getKey(hostName, contextPath);
        if (log.isDebugEnabled()) {
            log.debug("Remove mapping: " + key);
        }
        return this.mapping.remove(key) != null;
    }

    @Override
    public Map<String, String> getMappingTable() {
        return this.mapping;
    }

    @Override
    public Iterator<String> getGlobalNames() {
        return this.globals.keySet().iterator();
    }

    @Override
    public Iterator<IGlobalScope> getGlobalScopes() {
        return this.globals.values().iterator();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append(this.mapping).toString();
    }

    @Override
    public void addListener(IScopeListener listener) {
        this.scopeListeners.add(listener);
    }

    @Override
    public void addListener(IConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    @Override
    public void removeListener(IScopeListener listener) {
        this.scopeListeners.remove(listener);
    }

    @Override
    public void removeListener(IConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    protected void notifyScopeCreated(IScope scope) {
        for (IScopeListener listener : this.scopeListeners) {
            listener.notifyScopeCreated(scope);
        }
    }

    protected void notifyScopeRemoved(IScope scope) {
        for (IScopeListener listener : this.scopeListeners) {
            listener.notifyScopeRemoved(scope);
        }
    }

    protected void notifyConnected(IConnection conn) {
        for (IConnectionListener listener : this.connectionListeners) {
            listener.notifyConnected(conn);
        }
    }

    protected void notifyDisconnected(IConnection conn) {
        for (IConnectionListener listener : this.connectionListeners) {
            listener.notifyDisconnected(conn);
        }
    }
}

