/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.red5.server.LoaderMBean;

public class Shutdown {
    public static void main(String[] args) {
        try {
            JMXServiceURL url = null;
            JMXConnector jmxc = null;
            HashMap<String, String[]> env = null;
            if (null == args || args.length < 1) {
                System.out.println("Attempting to connect to RMI port: 9999");
                url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:9999/red5");
            } else {
                System.out.println("Attempting to connect to RMI port: " + args[0]);
                url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:" + args[0] + "/red5");
                if (args.length > 1) {
                    env = new HashMap<String, String[]>(1);
                    String[] credentials = new String[]{args[1], args[2]};
                    env.put("jmx.remote.credentials", credentials);
                }
            }
            jmxc = JMXConnectorFactory.connect(url, env);
            MBeanServerConnection mbs = jmxc.getMBeanServerConnection();
            ObjectName tomcatObjectName = new ObjectName("org.red5.server:type=TomcatLoader");
            ObjectName jettyObjectName = new ObjectName("org.red5.server:type=JettyLoader");
            LoaderMBean mbeanProxy = null;
            if (mbs.isRegistered(jettyObjectName)) {
                mbeanProxy = MBeanServerInvocationHandler.newProxyInstance(mbs, jettyObjectName, LoaderMBean.class, true);
                System.out.println("Red5 Jetty loader was found");
            } else if (mbs.isRegistered(tomcatObjectName)) {
                mbeanProxy = MBeanServerInvocationHandler.newProxyInstance(mbs, tomcatObjectName, LoaderMBean.class, true);
                System.out.println("Red5 Tomcat loader was found");
            } else {
                System.out.println("Red5 Loader was not found, is the server running?");
            }
            if (null != mbeanProxy) {
                System.out.println("Calling shutdown");
                mbeanProxy.shutdown();
            }
            jmxc.close();
        }
        catch (UndeclaredThrowableException e) {
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

