/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.red5.server.api.Red5;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;

public class Standalone {
    protected static Logger log = LoggerFactory.getLogger(Standalone.class);
    protected static String red5Config = "red5.xml";

    public static void raiseOriginalException(Throwable e) throws Throwable {
        while (e.getCause() != null) {
            e = e.getCause();
        }
        throw e;
    }

    public static void main(String[] args) throws Throwable {
        String conf;
        if (args.length == 1) {
            red5Config = args[0];
        }
        long time = System.currentTimeMillis();
        log.info("{} (http://www.osflash.org/red5)", (Object)Red5.getVersion());
        log.info("Loading Red5 global context from: {}", (Object)red5Config);
        String classpath = System.getProperty("java.class.path");
        String root = System.getProperty("red5.root");
        if (root != null) {
            conf = root + "/conf";
        } else {
            File fp = new File(red5Config);
            if (!(fp = fp.getCanonicalFile()).isFile()) {
                String[] paths;
                for (String element : paths = classpath.split(System.getProperty("path.separator"))) {
                    fp = new File(element + '/' + red5Config);
                    if ((fp = fp.getCanonicalFile()).isFile()) break;
                }
            }
            if (!fp.isFile()) {
                throw new Exception("could not find configuration file " + red5Config + " on your classpath " + classpath);
            }
            System.setProperty("red5.conf_file", red5Config);
            root = fp.getAbsolutePath();
            root = root.replace('\\', '/');
            int idx = root.lastIndexOf(47);
            conf = root.substring(0, idx);
            idx = conf.lastIndexOf(47);
            root = conf.substring(0, idx);
            if (System.getProperty("file.separator").equals("/")) {
                root = '/' + root;
            }
            System.setProperty("red5.root", root);
            log.info("Setting Red5 root to {}", (Object)root);
        }
        System.setProperty("red5.config_root", conf);
        log.info("Setting configuation root to {}", (Object)conf);
        Properties props = new Properties();
        props.load(new FileInputStream(conf + "/red5.properties"));
        for (Object o : props.keySet()) {
            String key = (String)o;
            if (key == null || key.equals("")) continue;
            System.setProperty(key, props.getProperty(key));
        }
        try {
            ContextSingletonBeanFactoryLocator.getInstance((String)red5Config).useBeanFactory("red5.common");
        }
        catch (Exception e) {
            Standalone.raiseOriginalException(e);
        }
        long startupIn = System.currentTimeMillis() - time;
        log.info("Startup done in: {} ms", (Object)startupIn);
    }
}

