/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.adapter;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.red5.io.IStreamableFile;
import org.red5.io.IStreamableFileFactory;
import org.red5.io.IStreamableFileService;
import org.red5.io.ITagReader;
import org.red5.io.StreamableFileFactory;
import org.red5.server.adapter.ApplicationMBean;
import org.red5.server.adapter.IApplication;
import org.red5.server.adapter.StatefulScopeWrappingAdapter;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.api.Red5;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.service.ServiceUtils;
import org.red5.server.api.so.ISharedObject;
import org.red5.server.api.so.ISharedObjectSecurity;
import org.red5.server.api.so.ISharedObjectSecurityService;
import org.red5.server.api.so.ISharedObjectService;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IBroadcastStreamService;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IOnDemandStream;
import org.red5.server.api.stream.IOnDemandStreamService;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IPlaylistSubscriberStream;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.IStreamPlaybackSecurity;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.red5.server.api.stream.IStreamSecurityService;
import org.red5.server.api.stream.IStreamService;
import org.red5.server.api.stream.ISubscriberStream;
import org.red5.server.api.stream.ISubscriberStreamService;
import org.red5.server.exception.ClientRejectedException;
import org.red5.server.scheduling.QuartzSchedulingService;
import org.red5.server.so.SharedObjectService;
import org.red5.server.stream.IBroadcastScope;
import org.red5.server.stream.IProviderService;
import org.red5.server.stream.ProviderService;
import org.red5.server.stream.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiThreadedApplicationAdapter
extends StatefulScopeWrappingAdapter
implements ISharedObjectService,
IBroadcastStreamService,
IOnDemandStreamService,
ISubscriberStreamService,
ISchedulingService,
IStreamSecurityService,
ISharedObjectSecurityService,
IStreamAwareScopeHandler,
ApplicationMBean {
    protected static Logger log = LoggerFactory.getLogger(MultiThreadedApplicationAdapter.class);
    private Set<IApplication> listeners = new HashSet<IApplication>();
    protected ISchedulingService schedulingService;
    private int clientTTL = 2;
    private int ghostConnsCleanupPeriod = 5;
    private String ghostCleanupJobName;
    private Set<IStreamPublishSecurity> publishSecurity = new HashSet<IStreamPublishSecurity>();
    private Set<IStreamPlaybackSecurity> playbackSecurity = new HashSet<IStreamPlaybackSecurity>();
    private Set<ISharedObjectSecurity> sharedObjectSecurity = new HashSet<ISharedObjectSecurity>();

    public void addListener(IApplication listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IApplication listener) {
        this.listeners.remove(listener);
    }

    public Set<IApplication> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    @Override
    public void registerStreamPublishSecurity(IStreamPublishSecurity handler) {
        this.publishSecurity.add(handler);
    }

    @Override
    public void unregisterStreamPublishSecurity(IStreamPublishSecurity handler) {
        this.publishSecurity.remove(handler);
    }

    @Override
    public Set<IStreamPublishSecurity> getStreamPublishSecurity() {
        return this.publishSecurity;
    }

    @Override
    public void registerStreamPlaybackSecurity(IStreamPlaybackSecurity handler) {
        this.playbackSecurity.add(handler);
    }

    @Override
    public void unregisterStreamPlaybackSecurity(IStreamPlaybackSecurity handler) {
        this.playbackSecurity.remove(handler);
    }

    @Override
    public Set<IStreamPlaybackSecurity> getStreamPlaybackSecurity() {
        return this.playbackSecurity;
    }

    @Override
    public void registerSharedObjectSecurity(ISharedObjectSecurity handler) {
        this.sharedObjectSecurity.add(handler);
    }

    @Override
    public void unregisterSharedObjectSecurity(ISharedObjectSecurity handler) {
        this.sharedObjectSecurity.remove(handler);
    }

    @Override
    public Set<ISharedObjectSecurity> getSharedObjectSecurity() {
        return this.sharedObjectSecurity;
    }

    protected boolean rejectClient() throws ClientRejectedException {
        throw new ClientRejectedException();
    }

    protected boolean rejectClient(Object reason) throws ClientRejectedException {
        throw new ClientRejectedException(reason);
    }

    @Override
    public boolean connect(IConnection conn, IScope scope, Object[] params) {
        if (!super.connect(conn, scope, params)) {
            return false;
        }
        boolean success = false;
        if (ScopeUtils.isApp(scope)) {
            success = this.appConnect(conn, params);
        } else if (ScopeUtils.isRoom(scope)) {
            success = this.roomConnect(conn, params);
        }
        return success;
    }

    @Override
    public boolean start(IScope scope) {
        if (!super.start(scope)) {
            return false;
        }
        if (ScopeUtils.isApp(scope)) {
            return this.appStart(scope);
        }
        return ScopeUtils.isRoom(scope) && this.roomStart(scope);
    }

    @Override
    public void disconnect(IConnection conn, IScope scope) {
        if (log.isDebugEnabled()) {
            log.debug("disconnect: {} << {}", (Object)conn, (Object)scope);
        }
        if (ScopeUtils.isApp(scope)) {
            this.appDisconnect(conn);
        } else if (ScopeUtils.isRoom(scope)) {
            this.roomDisconnect(conn);
        }
        super.disconnect(conn, scope);
    }

    @Override
    public void stop(IScope scope) {
        if (ScopeUtils.isApp(scope)) {
            this.appStop(scope);
        } else if (ScopeUtils.isRoom(scope)) {
            this.roomStop(scope);
        }
        super.stop(scope);
    }

    @Override
    public boolean join(IClient client, IScope scope) {
        if (!super.join(client, scope)) {
            return false;
        }
        if (ScopeUtils.isApp(scope)) {
            return this.appJoin(client, scope);
        }
        return ScopeUtils.isRoom(scope) && this.roomJoin(client, scope);
    }

    @Override
    public void leave(IClient client, IScope scope) {
        if (log.isDebugEnabled()) {
            log.debug("leave: {} << {}", (Object)client, (Object)scope);
        }
        if (ScopeUtils.isApp(scope)) {
            this.appLeave(client, scope);
        } else if (ScopeUtils.isRoom(scope)) {
            this.roomLeave(client, scope);
        }
        super.leave(client, scope);
    }

    @Override
    public boolean appStart(IScope app) {
        if (log.isDebugEnabled()) {
            log.debug("appStart: {}", (Object)app);
        }
        for (IApplication listener : this.listeners) {
            listener.appStart(app);
        }
        return true;
    }

    @Override
    public void appStop(IScope app) {
        if (log.isDebugEnabled()) {
            log.debug("appStop: {}", (Object)app);
        }
        for (IApplication listener : this.listeners) {
            listener.appStop(app);
        }
    }

    @Override
    public boolean roomStart(IScope room) {
        if (log.isDebugEnabled()) {
            log.debug("roomStart: {}", (Object)room);
        }
        for (IApplication listener : this.listeners) {
            listener.roomStart(room);
        }
        return true;
    }

    @Override
    public void roomStop(IScope room) {
        if (log.isDebugEnabled()) {
            log.debug("roomStop: {}", (Object)room);
        }
        for (IApplication listener : this.listeners) {
            listener.roomStop(room);
        }
    }

    @Override
    public boolean appConnect(IConnection conn, Object[] params) {
        if (log.isDebugEnabled()) {
            log.debug("appConnect: {}", (Object)conn);
        }
        for (IApplication listener : this.listeners) {
            listener.appConnect(conn, params);
        }
        return true;
    }

    @Override
    public boolean roomConnect(IConnection conn, Object[] params) {
        if (log.isDebugEnabled()) {
            log.debug("roomConnect: {}", (Object)conn);
        }
        for (IApplication listener : this.listeners) {
            listener.roomConnect(conn, params);
        }
        return true;
    }

    @Override
    public void appDisconnect(IConnection conn) {
        if (log.isDebugEnabled()) {
            log.debug("appDisconnect: {}", (Object)conn);
        }
        for (IApplication listener : this.listeners) {
            listener.appDisconnect(conn);
        }
    }

    @Override
    public void roomDisconnect(IConnection conn) {
        if (log.isDebugEnabled()) {
            log.debug("roomDisconnect: {}", (Object)conn);
        }
        for (IApplication listener : this.listeners) {
            listener.roomDisconnect(conn);
        }
    }

    @Override
    public boolean appJoin(IClient client, IScope app) {
        if (log.isDebugEnabled()) {
            log.debug("appJoin: {} >> {}", (Object)client, (Object)app);
        }
        for (IApplication listener : this.listeners) {
            listener.appJoin(client, app);
        }
        return true;
    }

    @Override
    public void appLeave(IClient client, IScope app) {
        if (log.isDebugEnabled()) {
            log.debug("appLeave: {} << {}", (Object)client, (Object)app);
        }
        for (IApplication listener : this.listeners) {
            listener.appLeave(client, app);
        }
    }

    @Override
    public boolean roomJoin(IClient client, IScope room) {
        if (log.isDebugEnabled()) {
            log.debug("roomJoin: {} >> {}", (Object)client, (Object)room);
        }
        for (IApplication listener : this.listeners) {
            listener.roomJoin(client, room);
        }
        return true;
    }

    @Override
    public void roomLeave(IClient client, IScope room) {
        if (log.isDebugEnabled()) {
            log.debug("roomLeave: {} << {}", (Object)client, (Object)room);
        }
        for (IApplication listener : this.listeners) {
            listener.roomLeave(client, room);
        }
    }

    public void measureBandwidth() {
        this.measureBandwidth(Red5.getConnectionLocal());
    }

    public void measureBandwidth(IConnection conn) {
        ServiceUtils.invokeOnConnection(conn, "onBWDone", new Object[0]);
    }

    @Override
    public boolean createSharedObject(IScope scope, String name, boolean persistent) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, SharedObjectService.class, false);
        return service.createSharedObject(scope, name, persistent);
    }

    @Override
    public ISharedObject getSharedObject(IScope scope, String name) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, SharedObjectService.class, false);
        return service.getSharedObject(scope, name);
    }

    @Override
    public ISharedObject getSharedObject(IScope scope, String name, boolean persistent) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, SharedObjectService.class, false);
        return service.getSharedObject(scope, name, persistent);
    }

    @Override
    public Set<String> getSharedObjectNames(IScope scope) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, SharedObjectService.class, false);
        return service.getSharedObjectNames(scope);
    }

    @Override
    public boolean hasSharedObject(IScope scope, String name) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, SharedObjectService.class, false);
        return service.hasSharedObject(scope, name);
    }

    @Override
    public boolean hasBroadcastStream(IScope scope, String name) {
        IProviderService service = (IProviderService)ScopeUtils.getScopeService(scope, IProviderService.class, ProviderService.class);
        return service.getLiveProviderInput(scope, name, false) != null;
    }

    @Override
    public IBroadcastStream getBroadcastStream(IScope scope, String name) {
        IStreamService service = (IStreamService)ScopeUtils.getScopeService(scope, IStreamService.class, StreamService.class);
        if (!(service instanceof StreamService)) {
            return null;
        }
        IBroadcastScope bs = ((StreamService)service).getBroadcastScope(scope, name);
        return (IClientBroadcastStream)bs.getAttribute("_transient_publishing_stream");
    }

    @Override
    public List<String> getBroadcastStreamNames(IScope scope) {
        IProviderService service = (IProviderService)ScopeUtils.getScopeService(scope, IProviderService.class, ProviderService.class);
        return service.getBroadcastStreamNames(scope);
    }

    @Override
    public boolean hasOnDemandStream(IScope scope, String name) {
        IProviderService service = (IProviderService)ScopeUtils.getScopeService(scope, IProviderService.class, ProviderService.class);
        return service.getVODProviderInput(scope, name) != null;
    }

    @Override
    public IOnDemandStream getOnDemandStream(IScope scope, String name) {
        log.warn("This won't work until the refactoring of the streaming code is complete.");
        IOnDemandStreamService service = (IOnDemandStreamService)ScopeUtils.getScopeService(scope, IOnDemandStreamService.class, StreamService.class, false);
        return service.getOnDemandStream(scope, name);
    }

    @Override
    public ISubscriberStream getSubscriberStream(IScope scope, String name) {
        log.warn("This won't work until the refactoring of the streaming code is complete.");
        ISubscriberStreamService service = (ISubscriberStreamService)ScopeUtils.getScopeService(scope, ISubscriberStreamService.class, StreamService.class, false);
        return service.getSubscriberStream(scope, name);
    }

    @Override
    public String addScheduledJob(int interval, IScheduledJob job) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService(this.scope, ISchedulingService.class, QuartzSchedulingService.class, false);
        return service.addScheduledJob(interval, job);
    }

    @Override
    public String addScheduledOnceJob(long timeDelta, IScheduledJob job) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService(this.scope, ISchedulingService.class, QuartzSchedulingService.class, false);
        return service.addScheduledOnceJob(timeDelta, job);
    }

    @Override
    public String addScheduledOnceJob(Date date, IScheduledJob job) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService(this.scope, ISchedulingService.class, QuartzSchedulingService.class, false);
        return service.addScheduledOnceJob(date, job);
    }

    @Override
    public String addScheduledJobAfterDelay(int interval, IScheduledJob job, int delay) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService(this.scope, ISchedulingService.class, QuartzSchedulingService.class, false);
        return service.addScheduledJobAfterDelay(interval, job, delay);
    }

    @Override
    public void removeScheduledJob(String name) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService(this.scope, ISchedulingService.class, QuartzSchedulingService.class, false);
        service.removeScheduledJob(name);
    }

    @Override
    public List<String> getScheduledJobNames() {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService(this.scope, ISchedulingService.class, QuartzSchedulingService.class, false);
        return service.getScheduledJobNames();
    }

    public double getStreamLength(String name) {
        IProviderService provider = (IProviderService)ScopeUtils.getScopeService(this.scope, IProviderService.class, ProviderService.class);
        File file = provider.getVODProviderFile(this.scope, name);
        if (file == null) {
            return 0.0;
        }
        double duration = 0.0;
        IStreamableFileFactory factory = (IStreamableFileFactory)ScopeUtils.getScopeService(this.scope, IStreamableFileFactory.class, StreamableFileFactory.class);
        IStreamableFileService service = factory.getService(file);
        if (service == null) {
            log.error("No service found for {}", (Object)file.getAbsolutePath());
            return 0.0;
        }
        try {
            IStreamableFile streamFile = service.getStreamableFile(file);
            ITagReader reader = streamFile.getReader();
            duration = (double)reader.getDuration() / 1000.0;
            reader.close();
        }
        catch (IOException e) {
            log.error("error read stream file {}. {}", (Object)file.getAbsolutePath(), (Object)e);
        }
        return duration;
    }

    @Override
    public boolean clearSharedObjects(IScope scope, String name) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService(scope, ISharedObjectService.class, SharedObjectService.class, false);
        return service.clearSharedObjects(scope, name);
    }

    public long getClientTTL() {
        return this.clientTTL;
    }

    public void setClientTTL(int clientTTL) {
        this.clientTTL = clientTTL;
    }

    public int getGhostConnsCleanupPeriod() {
        return this.ghostConnsCleanupPeriod;
    }

    public void setGhostConnsCleanupPeriod(int ghostConnsCleanupPeriod) {
        this.ghostConnsCleanupPeriod = ghostConnsCleanupPeriod;
    }

    public void scheduleGhostConnectionsCleanup() {
        IScheduledJob job = new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                MultiThreadedApplicationAdapter.this.killGhostConnections();
            }
        };
        this.cancelGhostConnectionsCleanup();
        this.ghostCleanupJobName = this.schedulingService.addScheduledJob(this.ghostConnsCleanupPeriod * 1000, job);
    }

    public void cancelGhostConnectionsCleanup() {
        if (this.ghostCleanupJobName != null) {
            this.schedulingService.removeScheduledJob(this.ghostCleanupJobName);
        }
    }

    protected void killGhostConnections() {
        Iterator<IConnection> iter = this.getConnectionsIter();
        while (iter.hasNext()) {
            IConnection conn = iter.next();
            conn.ping();
            if (conn.getLastPingTime() <= this.clientTTL * 1000) continue;
            this.disconnect(conn, this.scope);
        }
    }

    public void FCPublish(String streamName) {
    }

    public void FCUnpublish() {
    }

    @Override
    public void streamBroadcastClose(IBroadcastStream stream) {
    }

    @Override
    public void streamBroadcastStart(IBroadcastStream stream) {
    }

    @Override
    public void streamPlaylistItemPlay(IPlaylistSubscriberStream stream, IPlayItem item, boolean isLive) {
    }

    @Override
    public void streamPlaylistItemStop(IPlaylistSubscriberStream stream, IPlayItem item) {
    }

    @Override
    public void streamPlaylistVODItemPause(IPlaylistSubscriberStream stream, IPlayItem item, int position) {
    }

    @Override
    public void streamPlaylistVODItemResume(IPlaylistSubscriberStream stream, IPlayItem item, int position) {
    }

    @Override
    public void streamPlaylistVODItemSeek(IPlaylistSubscriberStream stream, IPlayItem item, int position) {
    }

    @Override
    public void streamPublishStart(IBroadcastStream stream) {
    }

    @Override
    public void streamRecordStart(IBroadcastStream stream) {
    }

    @Override
    public void streamSubscriberClose(ISubscriberStream stream) {
    }

    @Override
    public void streamSubscriberStart(ISubscriberStream stream) {
    }
}

