/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api.persistence;

import java.lang.reflect.Constructor;
import org.red5.server.api.persistence.IPersistenceStore;
import org.springframework.core.io.support.ResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUtils {
    private static Constructor<?> getPersistenceStoreConstructor(Class<?> theClass, Class<?>[] interfaces) throws Exception {
        Constructor<?> constructor = null;
        for (Class<?> interfaceClass : interfaces) {
            try {
                constructor = theClass.getConstructor(interfaceClass);
            }
            catch (NoSuchMethodException err) {
                // empty catch block
            }
            if (constructor != null || (constructor = PersistenceUtils.getPersistenceStoreConstructor(theClass, interfaceClass.getInterfaces())) != null) break;
        }
        return constructor;
    }

    public static IPersistenceStore getPersistenceStore(ResourcePatternResolver resolver, String className) throws Exception {
        Class<?> persistenceClass = Class.forName(className);
        Constructor<?> constructor = PersistenceUtils.getPersistenceStoreConstructor(persistenceClass, resolver.getClass().getInterfaces());
        if (constructor == null) {
            for (Class<?> superClass = resolver.getClass().getSuperclass(); superClass != null && (constructor = PersistenceUtils.getPersistenceStoreConstructor(persistenceClass, superClass.getInterfaces())) == null; superClass = superClass.getSuperclass()) {
            }
        }
        if (constructor == null) {
            throw new NoSuchMethodException();
        }
        return (IPersistenceStore)constructor.newInstance(resolver);
    }
}

