/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api.stream.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.red5.server.api.IScope;
import org.red5.server.api.stream.IServerStream;
import org.red5.server.stream.ServerStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamUtils.class);
    private static volatile Map<String, ServerStream> serverStreamMap = new ConcurrentHashMap<String, ServerStream>();

    public static IServerStream createServerStream(IScope scope, String name) {
        logger.debug("Creating server stream: " + name + " Scope: " + scope);
        ServerStream stream = new ServerStream();
        stream.setScope(scope);
        stream.setName(name);
        stream.setPublishedName(name);
        String key = scope.getName() + name;
        serverStreamMap.put(key, stream);
        return stream;
    }

    public static IServerStream getServerStream(IScope scope, String name) {
        logger.debug("Looking up server stream: " + name + " Scope: " + scope);
        String key = scope.getName() + name;
        if (serverStreamMap.containsKey(key)) {
            return serverStreamMap.get(key);
        }
        logger.warn("Server stream not found with key: " + key);
        return null;
    }
}

