/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.cache;

import com.whirlycott.cache.Cache;
import com.whirlycott.cache.CacheConfiguration;
import com.whirlycott.cache.CacheManager;
import com.whirlycott.cache.RecordKeeper;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import org.red5.server.api.cache.ICacheStore;
import org.red5.server.api.cache.ICacheable;
import org.red5.server.cache.CacheableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhirlyCacheImpl
implements ICacheStore,
ApplicationContextAware {
    protected static Logger log = LoggerFactory.getLogger(WhirlyCacheImpl.class);
    private static Cache cache;
    private CacheConfiguration cacheConfig;
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void init() {
        log.info("Loading whirlycache");
        try {
            CacheManager cm = CacheManager.getInstance();
            for (String nm : cm.getCacheNames()) {
                if (log.isDebugEnabled()) {
                    log.debug("Cache name: " + nm);
                }
                if (!nm.equals("default")) continue;
                cm.destroy("default");
            }
            cache = cm.createCache(this.cacheConfig);
        }
        catch (Exception e) {
            log.warn("Error on cache init", (Throwable)e);
        }
    }

    @Override
    public ICacheable get(String name) {
        return (ICacheable)cache.retrieve((Object)name);
    }

    @Override
    public void put(String name, Object obj) {
        if (obj instanceof ICacheable) {
            cache.store((Object)name, obj);
        } else {
            cache.store((Object)name, (Object)new CacheableImpl(obj));
        }
    }

    @Override
    public Iterator<String> getObjectNames() {
        return null;
    }

    @Override
    public Iterator<SoftReference<? extends ICacheable>> getObjects() {
        return null;
    }

    @Override
    public boolean offer(String name, Object obj) {
        cache.store((Object)name, obj);
        return true;
    }

    @Override
    public boolean remove(ICacheable obj) {
        return null != cache.remove((Object)obj.getName());
    }

    @Override
    public boolean remove(String name) {
        return null != cache.remove((Object)name);
    }

    public void setCacheConfig(CacheConfiguration cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    @Override
    public void setMaxEntries(int capacity) {
        if (log.isDebugEnabled()) {
            log.debug("Setting max entries for this cache to " + capacity);
        }
    }

    public static long getCacheHit() {
        RecordKeeper rec = new RecordKeeper();
        return rec.getHits();
    }

    public static long getCacheMiss() {
        long misses = 0L;
        RecordKeeper rec = new RecordKeeper();
        long hits = rec.getHits();
        long ops = rec.getTotalOperations();
        if (log.isDebugEnabled()) {
            log.debug("Hits: " + hits + " Operations: " + ops);
        }
        if (hits > 0L && ops > 0L) {
            misses = ops > hits ? ops - hits : hits - ops;
        } else if (hits < 0L && ops > 0L) {
            misses = ops;
        }
        return misses;
    }

    @Override
    public void destroy() {
        try {
            CacheManager.getInstance().shutdown();
        }
        catch (Exception e) {
            log.warn("Error on cache shutdown", (Throwable)e);
        }
    }
}

