/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.jboss;

import java.beans.Introspector;
import java.io.File;
import org.red5.server.jboss.JbossLoaderMBean;
import org.red5.server.jmx.JMXAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class JbossLoader
implements ApplicationContextAware,
JbossLoaderMBean {
    protected static ThreadLocal<ApplicationContext> applicationContext = new ThreadLocal();
    protected static Logger logger = LoggerFactory.getLogger((String)JbossLoader.class.getName());

    public void start() {
        logger.info("Loading JBoss service");
        System.setProperty("red5.deployment.type", "jboss");
        logger.info("RED5 Server (http://www.osflash.org/red5)");
        long time = System.currentTimeMillis();
        try {
            String root = System.getProperty("red5.root");
            logger.info("Red5 root: " + root);
            String configRoot = System.getProperty("red5.config_root");
            logger.info("Red5 config root: " + configRoot);
            String classpath = System.getProperty("java.class.path");
            System.setProperty("java.class.path", classpath + File.pathSeparatorChar + root + File.pathSeparatorChar + configRoot);
            logger.debug("Updated classpath: " + System.getProperty("java.class.path"));
            ClassPathXmlApplicationContext appCtx = new ClassPathXmlApplicationContext(configRoot + "beanRefContext.xml");
            this.setApplicationContext((ApplicationContext)appCtx);
        }
        catch (Exception e) {
            logger.error("Error during startup", (Throwable)e);
        }
        long startupIn = System.currentTimeMillis() - time;
        logger.info("Startup done in: " + startupIn + " ms");
    }

    public boolean isStarted() {
        return true;
    }

    public void stop() {
        logger.info("Shutting down JBoss context");
        try {
            Introspector.flushCaches();
            JMXAgent.shutdown();
            FileSystemXmlApplicationContext appContext = (FileSystemXmlApplicationContext)this.getApplicationContext();
            ConfigurableListableBeanFactory factory = appContext.getBeanFactory();
            if (factory.containsSingleton("default.context")) {
                for (String scope : factory.getRegisteredScopeNames()) {
                    logger.debug("Registered scope: " + scope);
                }
                for (String singleton : factory.getSingletonNames()) {
                    logger.debug("Registered singleton: " + singleton);
                }
                factory.destroySingletons();
            }
            appContext.close();
        }
        catch (Exception e) {
            logger.warn("JBoss could not be stopped", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationCtx) throws BeansException {
        logger.debug("Attempt to set app context");
        applicationContext.set(applicationCtx);
    }

    public ApplicationContext getApplicationContext() {
        logger.debug("Attempt to get app context");
        return applicationContext.get();
    }
}

