/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.jetty;

import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;
import org.red5.server.api.IApplicationLoader;
import org.red5.server.jetty.JettyApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class JettyApplicationLoader
implements IApplicationLoader {
    protected static Logger log = LoggerFactory.getLogger(JettyApplicationContext.class);
    private Server server;
    private ApplicationContext rootCtx;

    protected JettyApplicationLoader(Server server, ApplicationContext rootCtx) {
        this.server = server;
        this.rootCtx = rootCtx;
    }

    public ApplicationContext getRootContext() {
        return this.rootCtx;
    }

    public void loadApplication(String contextPath, String virtualHosts, String directory) throws Exception {
        String[] handlersArr = new String[]{"org.mortbay.jetty.webapp.WebInfConfiguration", "org.mortbay.jetty.webapp.WebXmlConfiguration", "org.mortbay.jetty.webapp.JettyWebXmlConfiguration", "org.mortbay.jetty.webapp.TagLibConfiguration", "org.red5.server.jetty.Red5WebPropertiesConfiguration"};
        WebAppContext context = new WebAppContext();
        String[] hostnames = null;
        if (virtualHosts != null) {
            hostnames = virtualHosts.split(",");
            for (int i = 0; i < hostnames.length; ++i) {
                hostnames[i] = hostnames[i].trim();
                if (!hostnames[i].equals("*")) continue;
                hostnames = null;
                break;
            }
        }
        context.setContextPath(contextPath);
        context.setVirtualHosts(hostnames);
        context.setConfigurationClasses(handlersArr);
        context.setDefaultsDescriptor("web-default.xml");
        context.setExtractWAR(true);
        context.setWar(directory);
        context.setParentLoaderPriority(true);
        context.setServer(this.server);
        context.start();
    }
}

