/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.jetty;

import java.util.EventListener;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;
import org.red5.server.Context;
import org.red5.server.ContextLoader;
import org.red5.server.LoaderBase;
import org.red5.server.WebScope;
import org.red5.server.adapter.ApplicationAdapter;
import org.red5.server.api.IClientRegistry;
import org.red5.server.api.IMappingStrategy;
import org.red5.server.api.IScopeResolver;
import org.red5.server.api.IServer;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.jetty.JettyApplicationContext;
import org.red5.server.jetty.JettyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class Red5WebPropertiesConfiguration
implements Configuration,
EventListener {
    private static final long serialVersionUID = 951479449391784526L;
    protected static Logger log = LoggerFactory.getLogger(Red5WebPropertiesConfiguration.class);
    protected WebAppContext _context;

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public WebAppContext getWebAppContext() {
        return this._context;
    }

    public void configureClassLoader() throws Exception {
        this._context.setParentLoaderPriority(false);
    }

    public void configureDefaults() throws Exception {
    }

    public void configureWebApp() throws Exception {
        log.debug("Configuring Jetty webapp");
        WebAppContext context = this.getWebAppContext();
        if (context.isStarted()) {
            log.debug("Cannot configure webapp after it is started");
            return;
        }
        Resource webInf = context.getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource config = webInf.addPath("red5-web.properties");
            if (config.exists()) {
                log.debug("Configuring red5-web.properties");
                Properties props = new Properties();
                props.load(config.getInputStream());
                String contextPath = props.getProperty("webapp.contextPath");
                String virtualHosts = props.getProperty("webapp.virtualHosts");
                String[] hostnames = virtualHosts.split(",");
                for (int i = 0; i < hostnames.length; ++i) {
                    hostnames[i] = hostnames[i].trim();
                    if (!hostnames[i].equals("*")) continue;
                    hostnames = null;
                    break;
                }
                context.setVirtualHosts(hostnames);
                context.setContextPath(contextPath);
                LoaderBase.setRed5ApplicationContext(contextPath, new JettyApplicationContext(context));
            }
        } else if (webInf == null) {
            log.info("No WEB-INF directory found for " + context.getContextPath() + ", creating default application.");
            BeanFactoryLocator bfl = ContextSingletonBeanFactoryLocator.getInstance((String)"red5.xml");
            BeanFactoryReference bfr = bfl.useBeanFactory("red5.common");
            WebScope scope = new WebScope();
            IServer server = (IServer)bfr.getFactory().getBean("red5.server");
            scope.setServer(server);
            scope.setGlobalScope(server.getGlobal("default"));
            ApplicationContext appCtx = JettyLoader.getApplicationContext();
            ContextLoader loader = (ContextLoader)appCtx.getBean("context.loader");
            appCtx = loader.getContext("default.context");
            Context scopeContext = new Context();
            scopeContext.setContextPath("/");
            scopeContext.setClientRegistry((IClientRegistry)appCtx.getBean("global.clientRegistry"));
            scopeContext.setMappingStrategy((IMappingStrategy)appCtx.getBean("global.mappingStrategy"));
            scopeContext.setServiceInvoker((IServiceInvoker)appCtx.getBean("global.serviceInvoker"));
            scopeContext.setScopeResolver((IScopeResolver)appCtx.getBean("red5.scopeResolver"));
            GenericWebApplicationContext webCtx = new GenericWebApplicationContext();
            webCtx.setDisplayName("Automatic generated WebAppContext");
            webCtx.setParent(appCtx);
            webCtx.setServletContext((ServletContext)ContextHandler.getCurrentContext());
            scopeContext.setApplicationContext((ApplicationContext)webCtx);
            scope.setContext(scopeContext);
            scope.setHandler(new ApplicationAdapter());
            scope.setContextPath(context.getContextPath());
            scope.setVirtualHosts("*");
            LoaderBase.setRed5ApplicationContext(context.getContextPath(), new JettyApplicationContext(context));
            scope.register();
        }
    }

    public void deconfigureWebApp() throws Exception {
    }
}

