/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.jmx;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.io.File;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.red5.server.jmx.JMXFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXAgent
implements NotificationListener {
    private static JMXConnectorServer cs;
    private static boolean enableHtmlAdapter;
    private static boolean enableRmiAdapter;
    private static boolean startRegistry;
    private static boolean enableSsl;
    private static boolean enableMinaMonitor;
    private static HtmlAdaptorServer html;
    private static String htmlAdapterPort;
    private static Logger log;
    private static MBeanServer mbs;
    private static String rmiAdapterPort;
    private static String remotePasswordProperties;
    private static String remoteAccessProperties;

    public static boolean registerMBean(Object instance, String className, Class interfaceClass) {
        boolean status = false;
        try {
            String cName = className;
            if (cName.indexOf(46) != -1) {
                cName = cName.substring(cName.lastIndexOf(46)).replaceFirst("[\\.]", "");
            }
            log.debug("Register name: {}", (Object)cName);
            mbs.registerMBean(new StandardMBean(instance, interfaceClass), new ObjectName(JMXFactory.getDefaultDomain() + ":type=" + cName));
            status = true;
        }
        catch (InstanceAlreadyExistsException iaee) {
            log.debug("Already registered: {}", (Object)className);
        }
        catch (Exception e) {
            log.error("Could not register the {} MBean. {}", (Object)className, (Object)e);
        }
        return status;
    }

    public static boolean registerMBean(Object instance, String className, Class interfaceClass, ObjectName name) {
        boolean status = false;
        try {
            String cName = className;
            if (cName.indexOf(46) != -1) {
                cName = cName.substring(cName.lastIndexOf(46)).replaceFirst("[\\.]", "");
            }
            log.debug("Register name: {}", (Object)cName);
            mbs.registerMBean(new StandardMBean(instance, interfaceClass), name);
            status = true;
        }
        catch (InstanceAlreadyExistsException iaee) {
            log.debug("Already registered: {}", (Object)className);
        }
        catch (Exception e) {
            log.error("Could not register the {} MBean. {}", (Object)className, (Object)e);
        }
        return status;
    }

    public static boolean registerMBean(Object instance, String className, Class interfaceClass, String name) {
        boolean status = false;
        try {
            String cName = className;
            if (cName.indexOf(46) != -1) {
                cName = cName.substring(cName.lastIndexOf(46)).replaceFirst("[\\.]", "");
            }
            log.debug("Register name: {}", (Object)cName);
            mbs.registerMBean(new StandardMBean(instance, interfaceClass), new ObjectName(JMXFactory.getDefaultDomain() + ":type=" + cName + ",name=" + name));
            status = true;
        }
        catch (InstanceAlreadyExistsException iaee) {
            log.debug("Already registered: {}", (Object)className);
        }
        catch (Exception e) {
            log.error("Could not register the {} MBean. {}", (Object)className, (Object)e);
        }
        return status;
    }

    public static void shutdown() {
        log.info("Shutting down JMX agent");
        if (null != cs) {
            try {
                cs.stop();
            }
            catch (Exception e) {
                log.error("Exception stopping JMXConnector server {}", (Throwable)e);
            }
        }
        if (null != html) {
            html.stop();
        }
        try {
            String domain = JMXFactory.getDefaultDomain();
            for (ObjectName oname : mbs.queryNames(new ObjectName(domain + ":*"), null)) {
                log.debug("Bean domain: {}", (Object)oname.getDomain());
                if (!domain.equals(oname.getDomain())) continue;
                JMXAgent.unregisterMBean(oname);
            }
        }
        catch (Exception e) {
            log.error("Exception unregistering mbeans {}", (Throwable)e);
        }
    }

    public static boolean unregisterMBean(ObjectName oName) {
        boolean unregistered = false;
        if (null != oName) {
            try {
                if (mbs.isRegistered(oName)) {
                    log.debug("Mbean is registered");
                    mbs.unregisterMBean(oName);
                    unregistered = !mbs.isRegistered(oName);
                } else {
                    log.debug("Mbean is not currently registered");
                }
            }
            catch (Exception e) {
                log.warn("Exception unregistering mbean {}", (Throwable)e);
            }
        }
        log.debug("leaving unregisterMBean...");
        return unregistered;
    }

    public static boolean updateMBeanAttribute(ObjectName oName, String key, int value) {
        boolean updated = false;
        if (null != oName) {
            try {
                if (mbs.isRegistered(oName)) {
                    mbs.setAttribute(oName, new Attribute("key", value));
                    updated = true;
                }
            }
            catch (Exception e) {
                log.error("Exception updating mbean attribute", (Throwable)e);
            }
        }
        return updated;
    }

    public static boolean updateMBeanAttribute(ObjectName oName, String key, String value) {
        boolean updated = false;
        if (null != oName) {
            try {
                if (mbs.isRegistered(oName)) {
                    mbs.setAttribute(oName, new Attribute("key", value));
                    updated = true;
                }
            }
            catch (Exception e) {
                log.error("Exception updating mbean attribute", (Throwable)e);
            }
        }
        return updated;
    }

    public String getHtmlAdapterPort() {
        return htmlAdapterPort;
    }

    public void handleNotification(Notification notification, Object handback) {
        log.debug("handleNotification " + notification.getMessage());
    }

    public void init() {
        block19: {
            HashMap<String, Object> env = null;
            if (enableHtmlAdapter) {
                try {
                    int port = htmlAdapterPort == null ? 8082 : Integer.valueOf(htmlAdapterPort);
                    html = new HtmlAdaptorServer(port);
                    ObjectName htmlName = new ObjectName(JMXFactory.getDefaultDomain() + ":type=HtmlAdaptorServer,port=" + port);
                    log.debug("Created HTML adaptor on port: " + port);
                    mbs.registerMBean(html, htmlName);
                    html.start();
                    log.info("JMX HTML connector server successfully started");
                }
                catch (Exception e) {
                    log.error("Error in setup of JMX subsystem (HTML adapter)", (Throwable)e);
                }
            } else {
                log.info("JMX HTML adapter was not enabled");
            }
            if (enableRmiAdapter) {
                log.debug("Create an RMI connector server");
                try {
                    block18: {
                        Registry r = null;
                        try {
                            r = LocateRegistry.getRegistry(Integer.valueOf(rmiAdapterPort));
                            for (String regName : r.list()) {
                                if (!regName.equals("red5")) continue;
                                r.unbind("red5");
                            }
                        }
                        catch (RemoteException re) {
                            log.info("RMI Registry server was not found on port " + rmiAdapterPort);
                            if (!startRegistry) break block18;
                            log.info("Starting an internal RMI registry");
                            r = LocateRegistry.createRegistry(Integer.valueOf(rmiAdapterPort));
                        }
                    }
                    JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:" + rmiAdapterPort + "/red5");
                    if (enableSsl) {
                        log.debug("Initialize the environment map");
                        env = new HashMap<String, Object>();
                        SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
                        SslRMIServerSocketFactory ssf = new SslRMIServerSocketFactory();
                        env.put("jmx.remote.rmi.client.socket.factory", csf);
                        env.put("jmx.remote.rmi.server.socket.factory", ssf);
                    }
                    if (StringUtils.isNotBlank((String)remoteAccessProperties)) {
                        File file;
                        if (null == env) {
                            env = new HashMap();
                        }
                        if (!(file = new File(remoteAccessProperties)).exists()) {
                            log.debug("Access file was not found on path, will prepend config_root");
                            remoteAccessProperties = System.getProperty("red5.config_root") + '/' + remoteAccessProperties;
                            remotePasswordProperties = System.getProperty("red5.config_root") + '/' + remotePasswordProperties;
                        }
                        env.put("jmx.remote.x.access.file", remoteAccessProperties);
                        env.put("jmx.remote.x.password.file", remotePasswordProperties);
                    }
                    cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
                    cs.addNotificationListener(this, null, null);
                    log.debug("Start the RMI connector server");
                    cs.start();
                    log.info("JMX RMI connector server successfully started");
                }
                catch (ConnectException e) {
                    log.warn("Could not establish RMI connection to port " + rmiAdapterPort + ", please make sure \"rmiregistry\" is running and configured to listen on this port.");
                }
                catch (IOException e) {
                    String errMsg = e.getMessage();
                    if (errMsg.indexOf("NameAlreadyBoundException") != -1) {
                        log.error("JMX connector (red5) already registered, you will need to restart your rmiregistry");
                        break block19;
                    }
                    log.error("{}", (Throwable)e);
                }
                catch (Exception e) {
                    log.error("Error in setup of JMX subsystem (RMI connector)", (Throwable)e);
                }
            } else {
                log.info("JMX RMI adapter was not enabled");
            }
        }
    }

    public void setEnableHtmlAdapter(boolean enableHtmlAdapter) {
        JMXAgent.enableHtmlAdapter = enableHtmlAdapter;
    }

    public void setEnableHtmlAdapter(String enableHtmlAdapterString) {
        enableHtmlAdapter = enableHtmlAdapterString.matches("true|on|yes");
    }

    public void setEnableRmiAdapter(boolean enableRmiAdapter) {
        JMXAgent.enableRmiAdapter = enableRmiAdapter;
    }

    public void setEnableRmiAdapter(String enableRmiAdapterString) {
        enableRmiAdapter = enableRmiAdapterString.matches("true|on|yes");
    }

    public void setEnableSsl(boolean enableSsl) {
        JMXAgent.enableSsl = enableSsl;
    }

    public void setEnableSsl(String enableSslString) {
        enableSsl = enableSslString.matches("true|on|yes");
    }

    public void setHtmlAdapterPort(String htmlAdapterPort) {
        JMXAgent.htmlAdapterPort = htmlAdapterPort;
    }

    public void setRemoteAccessProperties(String remoteAccessProperties) {
        JMXAgent.remoteAccessProperties = remoteAccessProperties;
    }

    public void setRemotePasswordProperties(String remotePasswordProperties) {
        JMXAgent.remotePasswordProperties = remotePasswordProperties;
    }

    public void setRmiAdapterPort(String rmiAdapterPort) {
        JMXAgent.rmiAdapterPort = rmiAdapterPort;
    }

    public void setStartRegistry(boolean startRegistry) {
        JMXAgent.startRegistry = startRegistry;
    }

    public void setEnableMinaMonitor(boolean enableMinaMonitor) {
        JMXAgent.enableMinaMonitor = enableMinaMonitor;
    }

    public void setEnableMinaMonitor(String enableMinaMonitor) {
        JMXAgent.enableMinaMonitor = enableMinaMonitor.matches("true|on|yes");
    }

    public static boolean isEnableMinaMonitor() {
        return enableMinaMonitor;
    }

    static {
        htmlAdapterPort = "8082";
        log = LoggerFactory.getLogger(JMXAgent.class);
        rmiAdapterPort = "9999";
        if (null == mbs) {
            mbs = JMXFactory.getMBeanServer();
        }
    }
}

