/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.messaging;

import java.io.IOException;
import java.util.Map;
import org.red5.server.messaging.AbstractPipe;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.IPullableProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryPullPullPipe
extends AbstractPipe {
    private static final Logger log = LoggerFactory.getLogger(InMemoryPullPullPipe.class);

    public boolean subscribe(IConsumer consumer, Map paramMap) {
        boolean success = super.subscribe(consumer, paramMap);
        if (success) {
            this.fireConsumerConnectionEvent(consumer, 3, paramMap);
        }
        return success;
    }

    public boolean subscribe(IProvider provider, Map paramMap) {
        if (!(provider instanceof IPullableProvider)) {
            throw new IllegalArgumentException("Non-pullable provider not supported by PullPullPipe");
        }
        boolean success = super.subscribe(provider, paramMap);
        if (success) {
            this.fireProviderConnectionEvent(provider, 0, paramMap);
        }
        return success;
    }

    public IMessage pullMessage() throws IOException {
        IMessage message = null;
        for (IProvider provider : this.providers) {
            if (!(provider instanceof IPullableProvider)) continue;
            try {
                message = ((IPullableProvider)provider).pullMessage(this);
                if (message == null) continue;
                break;
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                log.error("exception when pulling message from provider", t);
            }
        }
        return message;
    }

    public IMessage pullMessage(long wait) {
        IMessage message = null;
        int size = this.providers.size();
        long averageWait = size > 0 ? wait / (long)size : 0L;
        for (IProvider provider : this.providers) {
            if (!(provider instanceof IPullableProvider)) continue;
            try {
                message = ((IPullableProvider)provider).pullMessage(this, averageWait);
                if (message == null) continue;
                break;
            }
            catch (Throwable t) {
                log.error("exception when pulling message from provider", t);
            }
        }
        return message;
    }

    public void pushMessage(IMessage message) {
    }
}

