/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.messaging;

import java.io.IOException;
import java.util.Map;
import org.red5.server.messaging.AbstractPipe;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.IPushableConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryPushPushPipe
extends AbstractPipe {
    private static final Logger log = LoggerFactory.getLogger(InMemoryPushPushPipe.class);

    public boolean subscribe(IConsumer consumer, Map paramMap) {
        if (!(consumer instanceof IPushableConsumer)) {
            throw new IllegalArgumentException("Non-pushable consumer not supported by PushPushPipe");
        }
        boolean success = super.subscribe(consumer, paramMap);
        if (success) {
            this.fireConsumerConnectionEvent(consumer, 4, paramMap);
        }
        return success;
    }

    public boolean subscribe(IProvider provider, Map paramMap) {
        boolean success = super.subscribe(provider, paramMap);
        if (success) {
            this.fireProviderConnectionEvent(provider, 1, paramMap);
        }
        return success;
    }

    public IMessage pullMessage() {
        return null;
    }

    public IMessage pullMessage(long wait) {
        return null;
    }

    public void pushMessage(IMessage message) throws IOException {
        for (IConsumer consumer : this.consumers) {
            try {
                ((IPushableConsumer)consumer).pushMessage(this, message);
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                log.error("exception when pushing message to consumer", t);
            }
        }
    }
}

