/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.midi;

import java.util.ArrayList;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import org.red5.server.api.so.ISharedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedMidiObject {
    private static final Logger log = LoggerFactory.getLogger(SharedMidiObject.class);
    protected String deviceName;
    protected ISharedObject so;
    protected MidiDevice dev;

    public SharedMidiObject(String deviceName, ISharedObject so) {
        this.deviceName = deviceName;
        this.so = so;
    }

    public boolean connect() {
        try {
            this.dev = SharedMidiObject.getMidiDevice(this.deviceName);
            if (this.dev == null) {
                log.error("Midi device not found: " + this.deviceName);
                return false;
            }
            if (!this.dev.isOpen()) {
                this.dev.open();
            }
            this.dev.getTransmitter().setReceiver(new MidiReceiver());
            return true;
        }
        catch (MidiUnavailableException e) {
            log.error("Error connecting to midi device", (Throwable)e);
            return false;
        }
    }

    public void close() {
        if (this.dev != null && this.dev.isOpen()) {
            this.dev.close();
        }
    }

    public static MidiDevice getMidiDevice(String name) {
        MidiDevice.Info[] info;
        for (MidiDevice.Info element : info = MidiSystem.getMidiDeviceInfo()) {
            if (!element.getName().equals(name)) continue;
            try {
                return MidiSystem.getMidiDevice(element);
            }
            catch (MidiUnavailableException e) {
                log.error("{}", (Throwable)e);
            }
        }
        return null;
    }

    public class MidiReceiver
    implements Receiver {
        public void send(MidiMessage midi, long time) {
            byte[] msg = midi.getMessage();
            int len = midi.getLength();
            if (len <= 1) {
                return;
            }
            ArrayList<Object> list = new ArrayList<Object>(3);
            list.add(time);
            list.add(len);
            list.add(msg);
            SharedMidiObject.this.so.beginUpdate();
            SharedMidiObject.this.so.sendMessage("midi", list);
            SharedMidiObject.this.so.endUpdate();
            String out = "Midi >> Status: " + msg[0] + " Data: [";
            for (int i = 1; i < len; ++i) {
                out = out + msg[i] + (i == len - 1 ? "" : ",");
            }
            out = out + ']';
            log.debug(out);
        }

        public void close() {
            log.debug("Midi device closed");
        }
    }
}

