/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.midi;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Test {
    protected static Logger log = LoggerFactory.getLogger(Test.class);

    public static void main(String[] args) throws Exception {
        Test t = new Test();
    }

    public static MidiDevice getMidiDevice(String name) {
        MidiDevice.Info[] info;
        for (MidiDevice.Info element : info = MidiSystem.getMidiDeviceInfo()) {
            if (!element.getName().equals(name)) continue;
            try {
                return MidiSystem.getMidiDevice(element);
            }
            catch (MidiUnavailableException e) {
                log.error("{}", (Throwable)e);
            }
        }
        return null;
    }

    public Test() throws Exception {
        String MIDI_NAME = "USB Uno MIDI  In";
        MidiDevice dev = Test.getMidiDevice(MIDI_NAME);
        dev.open();
        MyReceiver rec = new MyReceiver();
        dev.getTransmitter().setReceiver(rec);
        Thread.sleep(20000L);
        dev.close();
    }

    public class MyReceiver
    implements Receiver {
        public void send(MidiMessage midi, long time) {
            byte[] msg = midi.getMessage();
            int len = midi.getLength();
            if (len <= 1) {
                return;
            }
            String out = "Status: " + msg[0] + " Data: [";
            for (int i = 1; i < len; ++i) {
                out = out + msg[i] + (i == len - 1 ? "" : ",");
            }
            out = out + ']';
            log.debug(out);
        }

        public void close() {
            log.debug("Closing");
        }
    }
}

