/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.mrtmp;

import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.red5.server.net.mrtmp.IMRTMPEdgeManager;
import org.red5.server.net.mrtmp.MRTMPEdgeConnection;
import org.red5.server.net.mrtmp.MRTMPPacket;
import org.red5.server.net.rtmp.IRTMPConnManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.message.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeMRTMPHandler
extends IoHandlerAdapter
implements Constants {
    private static final Logger log = LoggerFactory.getLogger(EdgeMRTMPHandler.class);
    private IRTMPConnManager rtmpConnManager;
    private IMRTMPEdgeManager mrtmpManager;
    private ProtocolCodecFactory codecFactory;

    public void setCodecFactory(ProtocolCodecFactory codecFactory) {
        this.codecFactory = codecFactory;
    }

    public void setMrtmpManager(IMRTMPEdgeManager mrtmpManager) {
        this.mrtmpManager = mrtmpManager;
    }

    public void setRtmpConnManager(IRTMPConnManager rtmpConnManager) {
        this.rtmpConnManager = rtmpConnManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession session, Object message) throws Exception {
        MRTMPPacket mrtmpPacket = (MRTMPPacket)message;
        int clientId = mrtmpPacket.getHeader().getClientId();
        RTMPConnection conn = this.rtmpConnManager.getConnection(clientId);
        if (conn == null) {
            log.debug("Client " + clientId + " is already closed.");
            return;
        }
        RTMP rtmpState = conn.getState();
        switch (mrtmpPacket.getHeader().getType()) {
            case 1: {
                RTMP rTMP = rtmpState;
                synchronized (rTMP) {
                    rtmpState.setState((byte)19);
                }
                conn.close();
                break;
            }
            case 2: {
                MRTMPPacket.RTMPHeader rtmpHeader = (MRTMPPacket.RTMPHeader)mrtmpPacket.getHeader();
                MRTMPPacket.RTMPBody rtmpBody = (MRTMPPacket.RTMPBody)mrtmpPacket.getBody();
                boolean toDisconnect = false;
                RTMP rTMP = rtmpState;
                synchronized (rTMP) {
                    Invoke invoke;
                    if (rtmpState.getState() == 18 && rtmpHeader.getRtmpType() == 20 && "connect".equals((invoke = (Invoke)rtmpBody.getRtmpPacket().getMessage()).getCall().getServiceMethodName())) {
                        if (invoke.getCall().getStatus() == 2) {
                            rtmpState.setState((byte)2);
                        } else {
                            toDisconnect = true;
                        }
                    }
                }
                log.debug("Forward packet to client: {}", (Object)rtmpBody.getRtmpPacket().getMessage());
                conn.write(rtmpBody.getRtmpPacket());
                if (toDisconnect) {
                    conn.close();
                }
                rTMP = rtmpState;
                synchronized (rTMP) {
                    if (rtmpState.getState() == 2) {
                        conn.startRoundTripMeasurement();
                    }
                    break;
                }
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    public void sessionClosed(IoSession session) throws Exception {
        MRTMPEdgeConnection conn = (MRTMPEdgeConnection)session.getAttachment();
        this.mrtmpManager.unregisterConnection(conn);
        conn.close();
        log.debug("Closed MRTMP Edge Connection " + conn);
    }

    public void sessionCreated(IoSession session) throws Exception {
        MRTMPEdgeConnection conn = new MRTMPEdgeConnection();
        conn.setIoSession(session);
        this.mrtmpManager.registerConnection(conn);
        session.setAttachment((Object)conn);
        session.getFilterChain().addFirst("protocolFilter", (IoFilter)new ProtocolCodecFilter(this.codecFactory));
        if (log.isDebugEnabled()) {
            session.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        log.debug("Created MRTMP Edge Connection " + conn);
    }
}

