/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.mrtmp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;

public class MRTMPClient
implements Runnable {
    private IoHandler ioHandler;
    private IoHandler ioHandlerWrapper;
    private String server;
    private int port;
    private Thread connectThread;
    private boolean needReconnect;

    public String getServer() {
        return this.server;
    }

    public void setServer(String address) {
        this.server = address;
    }

    public IoHandler getIoHandler() {
        return this.ioHandler;
    }

    public void setIoHandler(IoHandler ioHandler) {
        this.ioHandler = ioHandler;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void start() {
        this.needReconnect = true;
        this.ioHandlerWrapper = new IoHandlerWrapper(this.ioHandler);
        this.connectThread = new Thread((Runnable)this, "MRTMPClient");
        this.connectThread.setDaemon(true);
        this.connectThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            IoHandler ioHandler = this.ioHandlerWrapper;
            synchronized (ioHandler) {
                if (this.needReconnect) {
                    this.doConnect();
                    this.needReconnect = false;
                }
                try {
                    this.ioHandlerWrapper.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void doConnect() {
        SocketConnector connector = new SocketConnector();
        SocketConnectorConfig config = new SocketConnectorConfig();
        SocketSessionConfig sessionConf = config.getSessionConfig();
        sessionConf.setTcpNoDelay(true);
        while (true) {
            ConnectFuture future = connector.connect((SocketAddress)new InetSocketAddress(this.server, this.port), this.ioHandlerWrapper, (IoServiceConfig)config);
            future.join();
            if (future.isConnected()) break;
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        IoHandler ioHandler = this.ioHandlerWrapper;
        synchronized (ioHandler) {
            this.needReconnect = true;
            this.ioHandlerWrapper.notifyAll();
        }
    }

    private class IoHandlerWrapper
    implements IoHandler {
        private IoHandler wrapped;

        public IoHandlerWrapper(IoHandler wrapped) {
            this.wrapped = wrapped;
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            this.wrapped.exceptionCaught(session, cause);
            MRTMPClient.this.reconnect();
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            this.wrapped.messageReceived(session, message);
        }

        public void messageSent(IoSession session, Object message) throws Exception {
            this.wrapped.messageSent(session, message);
        }

        public void sessionClosed(IoSession session) throws Exception {
            this.wrapped.sessionClosed(session);
        }

        public void sessionCreated(IoSession session) throws Exception {
            this.wrapped.sessionCreated(session);
        }

        public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
            this.wrapped.sessionIdle(session, status);
        }

        public void sessionOpened(IoSession session) throws Exception {
            this.wrapped.sessionOpened(session);
        }
    }
}

