/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.mrtmp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.net.mrtmp.OriginMRTMPHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRTMPMinaTransport {
    private static final int DEFAULT_EVENT_THREADS_CORE = 16;
    private static final int DEFAULT_EVENT_THREADS_KEEPALIVE = 60;
    private static final int DEFAULT_EVENT_THREADS_MAX = 32;
    private static final int DEFAULT_EVENT_THREADS_QUEUE = -1;
    private static final int DEFAULT_IO_THREADS = Runtime.getRuntime().availableProcessors() + 1;
    private static final int DEFAULT_PORT = 1935;
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE = 262144;
    private static final int DEFAULT_SEND_BUFFER_SIZE = 65536;
    private static final boolean DEFAULT_TCP_NO_DELAY = false;
    private static final boolean DEFAULT_USE_HEAP_BUFFERS = true;
    private static final Log log = LogFactory.getLog(MRTMPMinaTransport.class);
    private SocketAcceptor acceptor;
    private String address = null;
    private ExecutorService eventExecutor;
    private int eventThreadsCore = 16;
    private int eventThreadsKeepalive = 60;
    private int eventThreadsMax = 32;
    private int eventThreadsQueue = -1;
    private IoHandlerAdapter ioHandler;
    private int ioThreads = DEFAULT_IO_THREADS;
    private boolean isLoggingTraffic = false;
    private ObjectName oName;
    private int port = 1935;
    private int receiveBufferSize = 262144;
    private int sendBufferSize = 65536;
    private boolean tcpNoDelay = false;
    private boolean useHeapBuffers = true;

    private void initIOHandler() {
        if (this.ioHandler == null) {
            log.info((Object)"No rtmp IO Handler associated - using defaults");
            this.ioHandler = new OriginMRTMPHandler();
        }
    }

    public void setAddress(String address) {
        if ("*".equals(address) || "0.0.0.0".equals(address)) {
            address = null;
        }
        this.address = address;
    }

    public void setEventThreadsCore(int eventThreadsCore) {
        this.eventThreadsCore = eventThreadsCore;
    }

    public void setEventThreadsKeepalive(int eventThreadsKeepalive) {
        this.eventThreadsKeepalive = eventThreadsKeepalive;
    }

    public void setEventThreadsMax(int eventThreadsMax) {
        this.eventThreadsMax = eventThreadsMax;
    }

    public void setEventThreadsQueue(int eventThreadsQueue) {
        this.eventThreadsQueue = eventThreadsQueue;
    }

    public void setIoHandler(IoHandlerAdapter rtmpIOHandler) {
        this.ioHandler = rtmpIOHandler;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public void setIsLoggingTraffic(boolean isLoggingTraffic) {
        this.isLoggingTraffic = isLoggingTraffic;
    }

    public void setPort(int port) {
        this.port = port;
        JMXAgent.updateMBeanAttribute(this.oName, "port", port);
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setUseHeapBuffers(boolean useHeapBuffers) {
        this.useHeapBuffers = useHeapBuffers;
    }

    public void start() throws Exception {
        this.initIOHandler();
        ByteBuffer.setUseDirectBuffers((!this.useHeapBuffers ? 1 : 0) != 0);
        if (this.useHeapBuffers) {
            ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        }
        log.info((Object)"MRTMP Mina Transport Settings");
        log.info((Object)("IO Threads: " + this.ioThreads));
        log.info((Object)("Event Threads: core: " + this.eventThreadsCore + "+1" + " max: " + this.eventThreadsMax + "+1" + " queue: " + this.eventThreadsQueue + " keepalive: " + this.eventThreadsKeepalive));
        this.eventExecutor = new ThreadPoolExecutor(this.eventThreadsCore + 1, this.eventThreadsMax + 1, this.eventThreadsKeepalive, TimeUnit.SECONDS, this.threadQueue(this.eventThreadsQueue));
        ((ThreadPoolExecutor)this.eventExecutor).setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        this.acceptor = new SocketAcceptor(this.ioThreads, (Executor)Executors.newCachedThreadPool());
        this.acceptor.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.eventExecutor));
        SocketAcceptorConfig config = this.acceptor.getDefaultConfig();
        config.setThreadModel(ThreadModel.MANUAL);
        config.setReuseAddress(false);
        config.setBacklog(100);
        log.info((Object)("TCP No Delay: " + this.tcpNoDelay));
        log.info((Object)("Receive Buffer Size: " + this.receiveBufferSize));
        log.info((Object)("Send Buffer Size: " + this.sendBufferSize));
        SocketSessionConfig sessionConf = config.getSessionConfig();
        sessionConf.setReuseAddress(true);
        sessionConf.setTcpNoDelay(this.tcpNoDelay);
        if (this.isLoggingTraffic) {
            log.info((Object)"Configuring traffic logging filter");
            LoggingFilter filter = new LoggingFilter();
            this.acceptor.getFilterChain().addFirst("LoggingFilter", (IoFilter)filter);
        }
        InetSocketAddress socketAddress = null;
        while (true) {
            try {
                socketAddress = this.address == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.address, this.port);
                this.acceptor.bind((SocketAddress)socketAddress, (IoHandler)this.ioHandler);
            }
            catch (Exception e) {
                ++this.port;
                continue;
            }
            break;
        }
        log.info((Object)("MRTMP Mina Transport bound to " + ((Object)socketAddress).toString()));
    }

    public void stop() {
        log.info((Object)"MRTMP Mina Transport unbind");
        this.acceptor.unbindAll();
        this.eventExecutor.shutdown();
    }

    private BlockingQueue<Runnable> threadQueue(int size) {
        switch (size) {
            case -1: {
                return new LinkedBlockingQueue<Runnable>();
            }
            case 0: {
                return new SynchronousQueue<Runnable>();
            }
        }
        return new ArrayBlockingQueue<Runnable>(size);
    }

    public String toString() {
        return "MRTMP Mina Transport [port=" + this.port + "]";
    }
}

