/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.mrtmp;

import org.apache.mina.common.ByteBuffer;
import org.red5.server.net.rtmp.message.Packet;

public class MRTMPPacket {
    public static final short CONNECT = 0;
    public static final short CLOSE = 1;
    public static final short RTMP = 2;
    public static final short JAVA_ENCODING = 0;
    public static final int COMMON_HEADER_LENGTH = 20;
    public static final int RTMP_HEADER_LENGTH = 24;
    private Header header;
    private Body body;

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MRTMPPacket: type=");
        switch (this.header.getType()) {
            case 0: {
                buf.append("CONNECT");
                break;
            }
            case 1: {
                buf.append("CLOSE");
                break;
            }
            case 2: {
                buf.append("RTMP");
                break;
            }
        }
        buf.append(",isDynamic=" + this.header.isDynamic());
        buf.append(",clientId=" + this.header.getClientId());
        if (this.header.getType() == 2) {
            RTMPHeader rtmpHeader = (RTMPHeader)this.header;
            buf.append(",rtmpType=" + rtmpHeader.rtmpType);
            RTMPBody rtmpBody = (RTMPBody)this.body;
            buf.append(",rtmpBody=" + rtmpBody.rtmpPacket.getMessage());
        }
        return buf.toString();
    }

    public static class RTMPBody
    extends Body {
        private Packet rtmpPacket;

        public Packet getRtmpPacket() {
            return this.rtmpPacket;
        }

        public void setRtmpPacket(Packet rtmpPacket) {
            this.rtmpPacket = rtmpPacket;
        }
    }

    public static class RTMPHeader
    extends Header {
        private int rtmpType;

        public int getRtmpType() {
            return this.rtmpType;
        }

        public void setRtmpType(int rtmpType) {
            this.rtmpType = rtmpType;
        }
    }

    public static class Body {
        private ByteBuffer rawBuf;

        public ByteBuffer getRawBuf() {
            return this.rawBuf;
        }

        public void setRawBuf(ByteBuffer rawBuf) {
            this.rawBuf = rawBuf;
        }
    }

    public static class Header {
        private short type;
        private short bodyEncoding;
        private boolean dynamic;
        private int clientId;
        private int headerLength;
        private int bodyLength;

        public int getBodyLength() {
            return this.bodyLength;
        }

        public void setBodyLength(int bodyLength) {
            this.bodyLength = bodyLength;
        }

        public int getClientId() {
            return this.clientId;
        }

        public void setClientId(int clientId) {
            this.clientId = clientId;
        }

        public int getHeaderLength() {
            return this.headerLength;
        }

        public void setHeaderLength(int headerLength) {
            this.headerLength = headerLength;
        }

        public short getType() {
            return this.type;
        }

        public void setType(short type) {
            this.type = type;
        }

        public short getBodyEncoding() {
            return this.bodyEncoding;
        }

        public void setBodyEncoding(short bodyEncoding) {
            this.bodyEncoding = bodyEncoding;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public void setDynamic(boolean dynamic) {
            this.dynamic = dynamic;
        }
    }
}

