/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.mrtmp;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.net.mrtmp.IMRTMPOriginManager;
import org.red5.server.net.mrtmp.MRTMPOriginConnection;
import org.red5.server.net.mrtmp.MRTMPPacket;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.RTMPOriginConnection;
import org.red5.server.stream.PlaylistSubscriberStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginMRTMPHandler
extends IoHandlerAdapter {
    private Logger log = LoggerFactory.getLogger(OriginMRTMPHandler.class);
    private IMRTMPOriginManager mrtmpManager;
    private ProtocolCodecFactory codecFactory;
    private IRTMPHandler handler;
    private Map<Integer, RTMPOriginConnection> dynConnMap = new HashMap<Integer, RTMPOriginConnection>();
    private Map<StaticConnId, RTMPOriginConnection> statConnMap = new HashMap<StaticConnId, RTMPOriginConnection>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public void setMrtmpManager(IMRTMPOriginManager mrtmpManager) {
        this.mrtmpManager = mrtmpManager;
    }

    public void setHandler(IRTMPHandler handler) {
        this.handler = handler;
    }

    public void setCodecFactory(ProtocolCodecFactory codecFactory) {
        this.codecFactory = codecFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession session, Object message) throws Exception {
        MRTMPPacket packet = (MRTMPPacket)message;
        MRTMPPacket.Header header = packet.getHeader();
        MRTMPPacket.Body body = packet.getBody();
        if (this.log.isDebugEnabled()) {
            this.log.debug(packet.toString());
        }
        int clientId = header.getClientId();
        int sessionId = this.getSessionId(session);
        MRTMPOriginConnection mrtmpConn = (MRTMPOriginConnection)session.getAttachment();
        RTMPOriginConnection conn = null;
        switch (packet.getHeader().getType()) {
            case 0: {
                this.lock.writeLock().lock();
                try {
                    if (header.isDynamic()) {
                        if (!this.dynConnMap.containsKey(clientId)) {
                            conn = new RTMPOriginConnection("polling", header.getClientId());
                            conn.setMrtmpManager(this.mrtmpManager);
                            conn.setHandler(this);
                            this.dynConnMap.put(clientId, conn);
                            break;
                        }
                        this.log.warn("Open an already existing RTMPT origin connection!");
                        break;
                    }
                    StaticConnId connId = new StaticConnId();
                    connId.clientId = header.getClientId();
                    connId.sessionId = sessionId;
                    if (!this.statConnMap.containsKey(connId)) {
                        conn = new RTMPOriginConnection("persistent", header.getClientId(), sessionId);
                        conn.setMrtmpManager(this.mrtmpManager);
                        conn.setHandler(this);
                        this.statConnMap.put(connId, conn);
                        break;
                    }
                    this.log.warn("Open an already existing RTMP origin connection!");
                    break;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            case 1: 
            case 2: {
                this.lock.readLock().lock();
                try {
                    if (header.isDynamic()) {
                        conn = this.dynConnMap.get(clientId);
                    } else {
                        StaticConnId connId = new StaticConnId();
                        connId.clientId = header.getClientId();
                        connId.sessionId = sessionId;
                        conn = this.statConnMap.get(connId);
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
                if (conn != null) {
                    if (packet.getHeader().getType() == 1) {
                        this.closeConnection(conn);
                        conn = null;
                        break;
                    }
                    MRTMPPacket.RTMPBody rtmpBody = (MRTMPPacket.RTMPBody)body;
                    this.handler.messageReceived(conn, conn.getState(), rtmpBody.getRtmpPacket());
                    break;
                }
                this.log.warn("Handle on a non-existent origin connection!");
                break;
            }
            default: {
                this.log.warn("Unknown mrtmp packet received!");
            }
        }
        if (conn != null) {
            this.mrtmpManager.associate(conn, mrtmpConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageSent(IoSession session, Object message) throws Exception {
        MRTMPPacket packet = (MRTMPPacket)message;
        if (packet.getHeader().getType() != 2) {
            return;
        }
        MRTMPPacket.Header header = packet.getHeader();
        MRTMPPacket.Body body = packet.getBody();
        int clientId = header.getClientId();
        int sessionId = this.getSessionId(session);
        RTMPOriginConnection conn = null;
        this.lock.readLock().lock();
        try {
            if (header.isDynamic()) {
                conn = this.dynConnMap.get(clientId);
            } else {
                StaticConnId connId = new StaticConnId();
                connId.clientId = header.getClientId();
                connId.sessionId = sessionId;
                conn = this.statConnMap.get(connId);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (conn != null) {
            MRTMPPacket.RTMPBody rtmpBody = (MRTMPPacket.RTMPBody)body;
            int channelId = rtmpBody.getRtmpPacket().getHeader().getChannelId();
            IClientStream stream = conn.getStreamByChannelId(channelId);
            if (stream != null && stream instanceof PlaylistSubscriberStream) {
                ((PlaylistSubscriberStream)stream).written(rtmpBody.getRtmpPacket().getMessage());
            }
        } else {
            this.log.warn("Handle on a non-existent origin connection!");
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        MRTMPOriginConnection conn = (MRTMPOriginConnection)session.getAttachment();
        this.mrtmpManager.unregisterConnection(conn);
        conn.close();
        this.log.debug("Closed MRTMP Origin Connection " + conn);
    }

    public void sessionCreated(IoSession session) throws Exception {
        MRTMPOriginConnection conn = new MRTMPOriginConnection();
        conn.setIoSession(session);
        this.mrtmpManager.registerConnection(conn);
        session.setAttachment((Object)conn);
        session.getFilterChain().addFirst("protocolFilter", (IoFilter)new ProtocolCodecFilter(this.codecFactory));
        if (this.log.isDebugEnabled()) {
            session.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.log.debug("Created MRTMP Origin Connection " + conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(RTMPOriginConnection conn) {
        boolean dynamic = !conn.getType().equals("persistent");
        this.lock.writeLock().lock();
        try {
            if (dynamic) {
                if (this.dynConnMap.containsKey(conn.getId())) {
                    this.dynConnMap.remove(conn.getId());
                    conn.realClose();
                } else {
                    this.log.warn("Close a non-existent origin connection!");
                }
            } else {
                StaticConnId connId = new StaticConnId();
                connId.clientId = conn.getId();
                connId.sessionId = conn.getIoSessionId();
                if (this.statConnMap.containsKey(connId)) {
                    this.statConnMap.remove(connId);
                    conn.realClose();
                } else {
                    this.log.warn("Close a non-existent origin connection!");
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.mrtmpManager.dissociate(conn);
    }

    protected int getSessionId(IoSession session) {
        MRTMPOriginConnection mrtmpConn = (MRTMPOriginConnection)session.getAttachment();
        if (mrtmpConn != null) {
            return mrtmpConn.hashCode();
        }
        return 0;
    }

    private class StaticConnId {
        public int sessionId;
        public int clientId;

        private StaticConnId() {
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.clientId;
            result = 31 * result + this.sessionId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StaticConnId other = (StaticConnId)obj;
            if (this.clientId != other.clientId) {
                return false;
            }
            return this.sessionId == other.sessionId;
        }
    }
}

