/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.mrtmp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.red5.server.net.mrtmp.IMRTMPConnection;
import org.red5.server.net.mrtmp.IMRTMPOriginManager;
import org.red5.server.net.mrtmp.OriginMRTMPHandler;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPOriginConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMRTMPOriginManager
implements IMRTMPOriginManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleMRTMPOriginManager.class);
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Set<IMRTMPConnection> connSet = new HashSet<IMRTMPConnection>();
    private Map<RTMPConnection, IMRTMPConnection> clientToConnMap = Collections.synchronizedMap(new HashMap());
    private OriginMRTMPHandler originMRTMPHandler;

    public void setOriginMRTMPHandler(OriginMRTMPHandler originMRTMPHandler) {
        this.originMRTMPHandler = originMRTMPHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerConnection(IMRTMPConnection conn) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.connSet.add(conn);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterConnection(IMRTMPConnection conn) {
        boolean ret;
        ArrayList<RTMPConnection> list = new ArrayList<RTMPConnection>();
        this.lock.writeLock().lock();
        try {
            ret = this.connSet.remove(conn);
            if (ret) {
                for (Map.Entry<RTMPConnection, IMRTMPConnection> entry : this.clientToConnMap.entrySet()) {
                    if (entry.getValue() != conn) continue;
                    list.add(entry.getKey());
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (RTMPConnection rtmpConn : list) {
            log.debug("Close RTMPOriginConnection " + rtmpConn.getId() + " due to MRTMP Connection closed!");
            this.originMRTMPHandler.closeConnection((RTMPOriginConnection)rtmpConn);
        }
        return ret;
    }

    public void associate(RTMPConnection rtmpConn, IMRTMPConnection mrtmpConn) {
        this.clientToConnMap.put(rtmpConn, mrtmpConn);
    }

    public void dissociate(RTMPConnection rtmpConn) {
        this.clientToConnMap.remove(rtmpConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMRTMPConnection lookupMRTMPConnection(RTMPConnection rtmpConn) {
        this.lock.readLock().lock();
        try {
            IMRTMPConnection conn = this.clientToConnMap.get(rtmpConn);
            if (conn != null && !this.connSet.contains(conn)) {
                this.clientToConnMap.remove(rtmpConn);
                conn = null;
            }
            if (conn == null && !rtmpConn.getType().equals("persistent") && this.connSet.size() > 0) {
                conn = this.connSet.iterator().next();
            }
            IMRTMPConnection iMRTMPConnection = conn;
            return iMRTMPConnection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

