/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.mrtmp.codec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.red5.server.net.mrtmp.MRTMPPacket;
import org.red5.server.net.rtmp.message.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRTMPProtocolDecoder
implements ProtocolDecoder {
    private static final Logger log = LoggerFactory.getLogger(MRTMPProtocolDecoder.class);

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        ByteBuffer buffer = (ByteBuffer)session.getAttribute("buffer");
        if (buffer == null) {
            buffer = ByteBuffer.allocate((int)16384);
            buffer.setAutoExpand(true);
            session.setAttribute("buffer", (Object)buffer);
        }
        buffer.put(in);
        buffer.flip();
        while (buffer.remaining() >= 20) {
            int pos = buffer.position();
            MRTMPPacket.Header header = this.decodeHeader(buffer);
            if (header == null) {
                buffer.position(pos);
                break;
            }
            if (buffer.remaining() < header.getBodyLength()) {
                buffer.position(pos);
                break;
            }
            MRTMPPacket.Body body = this.decodeBody(buffer, header);
            MRTMPPacket packet = new MRTMPPacket();
            packet.setHeader(header);
            packet.setBody(body);
            if (log.isDebugEnabled()) {
                log.debug(packet.toString());
            }
            out.write((Object)packet);
        }
        buffer.compact();
    }

    public void dispose(IoSession session) throws Exception {
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
        ByteBuffer buffer = (ByteBuffer)session.getAttribute("buffer");
        if (buffer != null) {
            buffer.release();
        }
    }

    public MRTMPPacket.Header decodeHeader(ByteBuffer buffer) {
        short type = buffer.getShort();
        short bodyEncoding = buffer.getShort();
        int preserved = buffer.getInt();
        int clientId = buffer.getInt();
        int headerLength = buffer.getInt();
        int bodyLength = buffer.getInt();
        if (buffer.remaining() < headerLength - 20) {
            return null;
        }
        MRTMPPacket.Header header = null;
        if (type == 2 && headerLength != 24) {
            log.warn("Codec error: wrong RTMP header length " + headerLength);
            header = new MRTMPPacket.Header();
            buffer.skip(headerLength - 20);
        } else if (type == 2) {
            MRTMPPacket.Header rtmpHeader = header = new MRTMPPacket.RTMPHeader();
            ((MRTMPPacket.RTMPHeader)rtmpHeader).setRtmpType(buffer.getInt());
        } else {
            header = new MRTMPPacket.Header();
            buffer.skip(headerLength - 20);
        }
        header.setType(type);
        header.setBodyEncoding(bodyEncoding);
        header.setDynamic((preserved & 0x8000000) != 0);
        header.setClientId(clientId);
        header.setHeaderLength(headerLength);
        header.setBodyLength(bodyLength);
        return header;
    }

    public MRTMPPacket.Body decodeBody(ByteBuffer buffer, MRTMPPacket.Header header) {
        MRTMPPacket.Body body = null;
        switch (header.getType()) {
            case 0: 
            case 1: {
                if (header.getBodyLength() != 0) {
                    log.warn("Codec error: wrong connect/close body length " + header.getBodyLength());
                }
                return new MRTMPPacket.Body();
            }
            case 2: {
                byte[] byteArray = new byte[header.getBodyLength()];
                buffer.get(byteArray);
                ObjectInputStream ois = null;
                try {
                    ois = new ObjectInputStream(new ByteArrayInputStream(byteArray));
                    Packet packet = (Packet)ois.readObject();
                    body = new MRTMPPacket.RTMPBody();
                    MRTMPPacket.RTMPBody rtmpBody = (MRTMPPacket.RTMPBody)body;
                    rtmpBody.setRtmpPacket(packet);
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error("", (Throwable)e);
                }
                break;
            }
            default: {
                byte[] byteArray = new byte[header.getBodyLength()];
                buffer.get(byteArray);
                body = new MRTMPPacket.Body();
                body.setRawBuf(ByteBuffer.wrap((byte[])byteArray));
            }
        }
        return body;
    }
}

