/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.mrtmp.codec;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.red5.server.net.mrtmp.MRTMPPacket;

public class MRTMPProtocolEncoder
implements ProtocolEncoder {
    public void dispose(IoSession session) throws Exception {
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        MRTMPPacket packet = (MRTMPPacket)message;
        MRTMPPacket.Header header = packet.getHeader();
        ByteBuffer buf = null;
        switch (header.getType()) {
            case 0: 
            case 1: {
                buf = ByteBuffer.allocate((int)20);
                buf.setAutoExpand(true);
                break;
            }
            case 2: {
                buf = ByteBuffer.allocate((int)24);
                buf.setAutoExpand(true);
                break;
            }
        }
        if (buf == null) {
            return;
        }
        buf.putShort(header.getType());
        buf.putShort((short)0);
        int preserved = header.isDynamic() ? Integer.MIN_VALUE : 0;
        buf.putInt(preserved);
        buf.putInt(header.getClientId());
        if (header.getType() == 0 || header.getType() == 1) {
            buf.putInt(20);
            buf.putInt(0);
        } else if (header.getType() == 2) {
            buf.putInt(24);
            int bodyLengthPos = buf.position();
            buf.putInt(0);
            MRTMPPacket.RTMPHeader rtmpHeader = (MRTMPPacket.RTMPHeader)packet.getHeader();
            buf.putInt(rtmpHeader.getRtmpType());
            MRTMPPacket.RTMPBody body = (MRTMPPacket.RTMPBody)packet.getBody();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(body.getRtmpPacket());
            oos.close();
            buf.put(baos.toByteArray());
            buf.putInt(bodyLengthPos, buf.position() - bodyLengthPos - 8);
        }
        buf.flip();
        out.write(buf);
    }
}

