/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.protocol;

import java.util.ArrayList;
import org.red5.server.exception.ClientDetailsException;
import org.red5.server.net.protocol.SimpleProtocolEncoder;
import org.red5.server.net.rtmp.status.StatusObject;

public abstract class BaseProtocolEncoder
implements SimpleProtocolEncoder {
    protected StatusObject generateErrorResult(String code, Throwable error) {
        String message = "";
        while (error != null && error.getCause() != null) {
            error = error.getCause();
        }
        if (error != null && error.getMessage() != null) {
            message = error.getMessage();
        }
        StatusObject status = new StatusObject(code, "error", message);
        if (error instanceof ClientDetailsException) {
            status.setApplication(((ClientDetailsException)error).getParameters());
            if (((ClientDetailsException)error).includeStacktrace()) {
                ArrayList<String> stack = new ArrayList<String>();
                for (StackTraceElement element : error.getStackTrace()) {
                    stack.add(element.toString());
                }
                status.setAdditional("stacktrace", stack);
            }
        } else if (error != null) {
            status.setApplication(error.getClass().getCanonicalName());
        }
        return status;
    }
}

