/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.proxy;

import java.io.File;
import java.io.FileOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.FileChannel;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.red5.server.net.proxy.NetworkDumpFilter;
import org.red5.server.net.proxy.ProxyFilter;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class DebugProxyHandler
extends IoHandlerAdapter
implements ResourceLoaderAware {
    protected static Logger log = LoggerFactory.getLogger((String)DebugProxyHandler.class.getName());
    private ResourceLoader loader;
    private ProtocolCodecFactory codecFactory;
    private InetSocketAddress forward;
    private String dumpTo = "./dumps/";

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader;
    }

    public void setCodecFactory(ProtocolCodecFactory codecFactory) {
        this.codecFactory = codecFactory;
    }

    public void setForward(String forward) {
        int split = forward.indexOf(58);
        String host = forward.substring(0, split);
        int port = Integer.parseInt(forward.substring(split + 1, forward.length()));
        this.forward = new InetSocketAddress(host, port);
    }

    public void setDumpTo(String dumpTo) {
        this.dumpTo = dumpTo;
    }

    public void sessionOpened(IoSession session) throws Exception {
        SocketSessionConfig ssc = (SocketSessionConfig)session.getConfig();
        ssc.setTcpNoDelay(true);
        super.sessionOpened(session);
    }

    public void sessionCreated(IoSession session) throws Exception {
        boolean isClient = session.getRemoteAddress().equals(this.forward);
        if (log.isDebugEnabled()) {
            log.debug("Is downstream: " + isClient);
            session.setAttribute("protocol_state", (Object)new RTMP(isClient));
            session.getFilterChain().addFirst("protocol", (IoFilter)new ProtocolCodecFilter(this.codecFactory));
        }
        session.getFilterChain().addFirst("proxy", (IoFilter)new ProxyFilter(isClient ? "client" : "server"));
        String fileName = System.currentTimeMillis() + 95L + this.forward.getHostName() + '_' + this.forward.getPort() + '_' + (isClient ? "DOWNSTREAM" : "UPSTREAM");
        File headersFile = this.loader.getResource(this.dumpTo + fileName + ".cap").getFile();
        headersFile.createNewFile();
        File rawFile = this.loader.getResource(this.dumpTo + fileName + ".raw").getFile();
        rawFile.createNewFile();
        FileOutputStream headersFos = new FileOutputStream(headersFile);
        FileChannel headers = headersFos.getChannel();
        FileOutputStream rawFos = new FileOutputStream(rawFile);
        FileChannel raw = rawFos.getChannel();
        ByteBuffer header = ByteBuffer.allocate((int)1);
        header.put((byte)(!isClient ? 1 : 0));
        header.flip();
        headers.write(header.buf());
        session.getFilterChain().addFirst("dump", (IoFilter)new NetworkDumpFilter(headers, raw));
        if (!isClient) {
            log.debug("Connecting..");
            SocketConnector connector = new SocketConnector();
            ConnectFuture future = connector.connect((SocketAddress)this.forward, (IoHandler)this);
            future.join();
            if (future.isConnected()) {
                if (log.isDebugEnabled()) {
                    log.debug("Connected: " + this.forward);
                }
                IoSession client = future.getSession();
                client.setAttribute("proxy_forward_key", (Object)session);
                session.setAttribute("proxy_forward_key", (Object)client);
            }
        }
        super.sessionCreated(session);
    }

    public void messageReceived(IoSession session, Object in) {
        if (!log.isDebugEnabled()) {
            return;
        }
        if (in instanceof ByteBuffer) {
            log.debug("Handskake");
            return;
        }
        try {
            Packet packet = (Packet)in;
            IRTMPEvent message = packet.getMessage();
            Header source = packet.getHeader();
            log.debug("{}", (Object)source);
            log.debug("{}", (Object)message);
        }
        catch (RuntimeException e) {
            log.error("Exception", (Throwable)e);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Exception caught", cause);
        }
    }
}

