/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.proxy;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFilter
extends IoFilterAdapter {
    public static final String FORWARD_KEY = "proxy_forward_key";
    protected static Logger log = LoggerFactory.getLogger(ProxyFilter.class);
    protected String name;

    public ProxyFilter(String name) {
        this.name = name;
    }

    public void messageReceived(IoFilter.NextFilter next, IoSession session, Object message) throws Exception {
        IoSession forward = (IoSession)session.getAttribute(FORWARD_KEY);
        if (forward != null && forward.isConnected() && message instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)message;
            if (log.isDebugEnabled()) {
                log.debug("[ " + this.name + " ] RAW >> " + buf.getHexDump());
            }
            ByteBuffer copy = ByteBuffer.allocate((int)buf.limit());
            int limit = buf.limit();
            copy.put(buf);
            copy.flip();
            forward.write((Object)copy);
            buf.flip();
            buf.position(0);
            buf.limit(limit);
        }
        next.messageReceived(session, message);
    }

    public void sessionClosed(IoFilter.NextFilter next, IoSession session) throws Exception {
        IoSession forward = (IoSession)session.getAttribute(FORWARD_KEY);
        if (forward != null && forward.isConnected() && !forward.isClosing()) {
            if (log.isDebugEnabled()) {
                log.debug("[ " + this.name + " ] Closing: " + forward);
            }
            forward.close();
        }
        next.sessionClosed(session);
    }
}

