/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.remoting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.red5.server.Client;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.IBasicScope;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.remoting.IRemotingConnection;
import org.red5.server.api.remoting.IRemotingHeader;
import org.red5.server.net.remoting.RemotingHeader;
import org.red5.server.net.remoting.message.RemotingPacket;
import org.red5.server.net.servlet.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotingConnection
implements IRemotingConnection {
    private static final String CLIENT = "red5.client";
    protected IScope scope;
    protected HttpServletRequest request;
    protected RemotingPacket packet;
    protected HttpSession session;
    protected List<IRemotingHeader> headers = new ArrayList<IRemotingHeader>();

    public RemotingConnection(HttpServletRequest request, IScope scope, RemotingPacket packet) {
        this.request = request;
        this.scope = scope;
        this.packet = packet;
        this.session = request.getSession();
        RemotingClient client = (RemotingClient)this.session.getAttribute(CLIENT);
        if (client == null) {
            client = new RemotingClient(this.session.getId());
            this.session.setAttribute(CLIENT, (Object)client);
        }
        client.register(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " from " + this.getRemoteAddress() + ':' + this.getRemotePort() + " to " + this.getHost() + " (session: " + this.session.getId() + ')';
    }

    protected void setPacket(RemotingPacket packet) {
        this.packet = packet;
    }

    private void notSupported() {
        throw new RuntimeException("not supported for this type of connection");
    }

    @Override
    public IConnection.Encoding getEncoding() {
        return this.packet.getEncoding();
    }

    @Override
    public String getType() {
        return "transient";
    }

    @Override
    public void initialize(IClient client) {
        this.notSupported();
    }

    @Override
    public boolean connect(IScope scope) {
        this.notSupported();
        return false;
    }

    @Override
    public boolean connect(IScope scope, Object[] params) {
        this.notSupported();
        return false;
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public void close() {
        this.session.invalidate();
    }

    @Override
    public Map<String, Object> getConnectParams() {
        return this.packet.getHeaders();
    }

    @Override
    public IClient getClient() {
        return (IClient)this.session.getAttribute(CLIENT);
    }

    @Override
    public String getHost() {
        return this.request.getLocalName();
    }

    @Override
    public String getRemoteAddress() {
        return this.request.getRemoteAddr();
    }

    @Override
    public List<String> getRemoteAddresses() {
        return ServletUtils.getRemoteAddresses(this.request);
    }

    @Override
    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    @Override
    public String getPath() {
        String path = this.request.getContextPath();
        if (this.request.getPathInfo() != null) {
            path = path + this.request.getPathInfo();
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    @Override
    public String getSessionId() {
        return null;
    }

    @Override
    public long getReadBytes() {
        return this.request.getContentLength();
    }

    @Override
    public long getWrittenBytes() {
        return 0L;
    }

    @Override
    public long getPendingMessages() {
        return 0L;
    }

    public long getPendingVideoMessages() {
        return 0L;
    }

    @Override
    public long getReadMessages() {
        return 1L;
    }

    @Override
    public long getWrittenMessages() {
        return 0L;
    }

    @Override
    public long getDroppedMessages() {
        return 0L;
    }

    @Override
    public void ping() {
        this.notSupported();
    }

    @Override
    public int getLastPingTime() {
        return -1;
    }

    @Override
    public IScope getScope() {
        return this.scope;
    }

    @Override
    public Iterator<IBasicScope> getBasicScopes() {
        this.notSupported();
        return null;
    }

    public void dispatchEvent(Object event) {
        this.notSupported();
    }

    @Override
    public void dispatchEvent(IEvent event) {
        this.notSupported();
    }

    @Override
    public boolean handleEvent(IEvent event) {
        this.notSupported();
        return false;
    }

    @Override
    public void notifyEvent(IEvent event) {
        this.notSupported();
    }

    @Override
    public Boolean getBoolAttribute(String name) {
        return (Boolean)this.getAttribute(name);
    }

    @Override
    public Byte getByteAttribute(String name) {
        return (Byte)this.getAttribute(name);
    }

    @Override
    public Double getDoubleAttribute(String name) {
        return (Double)this.getAttribute(name);
    }

    @Override
    public Integer getIntAttribute(String name) {
        return (Integer)this.getAttribute(name);
    }

    @Override
    public List getListAttribute(String name) {
        return (List)this.getAttribute(name);
    }

    @Override
    public Long getLongAttribute(String name) {
        return (Long)this.getAttribute(name);
    }

    @Override
    public Map getMapAttribute(String name) {
        return (Map)this.getAttribute(name);
    }

    @Override
    public Set getSetAttribute(String name) {
        return (Set)this.getAttribute(name);
    }

    @Override
    public Short getShortAttribute(String name) {
        return (Short)this.getAttribute(name);
    }

    @Override
    public String getStringAttribute(String name) {
        return (String)this.getAttribute(name);
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.session.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name, Object defaultValue) {
        if (name == null) {
            return null;
        }
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            Object result = this.session.getAttribute(name);
            if (result == null && defaultValue != null) {
                this.session.setAttribute(name, defaultValue);
                result = defaultValue;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAttributeNames() {
        HashSet result = new HashSet();
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            Enumeration names = this.session.getAttributeNames();
            while (names.hasMoreElements()) {
                result.add(names.nextElement());
            }
        }
        return Collections.unmodifiableSet(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            Enumeration names = this.session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                result.put(name, this.session.getAttribute(name));
            }
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public boolean hasAttribute(String name) {
        if (name == null) {
            return false;
        }
        return this.getAttribute(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAttribute(String name) {
        if (name == null) {
            return false;
        }
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            if (!this.hasAttribute(name)) {
                return false;
            }
            this.session.removeAttribute(name);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttributes() {
        HttpSession httpSession = this.session;
        synchronized (httpSession) {
            Enumeration names = this.session.getAttributeNames();
            while (names.hasMoreElements()) {
                this.session.removeAttribute((String)names.nextElement());
            }
        }
    }

    @Override
    public boolean setAttribute(String name, Object value) {
        if (name == null) {
            return false;
        }
        if (value == null) {
            this.session.removeAttribute(name);
        } else {
            this.session.setAttribute(name, value);
        }
        return true;
    }

    @Override
    public void setAttributes(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (name == null || value == null) continue;
            this.session.setAttribute(name, value);
        }
    }

    @Override
    public void setAttributes(IAttributeStore values) {
        this.setAttributes(values.getAttributes());
    }

    @Override
    public void addHeader(String name, Object value) {
        this.addHeader(name, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHeader(String name, Object value, boolean mustUnderstand) {
        List<IRemotingHeader> list = this.headers;
        synchronized (list) {
            this.headers.add(new RemotingHeader(name, mustUnderstand, value));
        }
    }

    @Override
    public void removeHeader(String name) {
        this.addHeader(name, null, false);
    }

    @Override
    public Collection<IRemotingHeader> getHeaders() {
        return this.headers;
    }

    @Override
    public long getClientBytesRead() {
        return 0L;
    }

    private class RemotingClient
    extends Client {
        private RemotingClient(String id) {
            super(id, null);
        }

        protected void register(IConnection conn) {
            for (IConnection c : this.getConnections()) {
                this.unregister(c);
            }
            super.register(conn);
        }
    }
}

