/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.util.HashSet;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.Red5;
import org.red5.server.api.event.IEventDispatcher;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.net.protocol.ProtocolState;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmp.status.StatusCodes;
import org.red5.server.so.SharedObjectMessage;
import org.red5.server.stream.PlaylistSubscriberStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class BaseRTMPHandler
implements IRTMPHandler,
Constants,
StatusCodes,
ApplicationContextAware {
    protected static Logger log = LoggerFactory.getLogger(BaseRTMPHandler.class);
    protected ApplicationContext appCtx;
    private static ThreadLocal<Integer> streamLocal = new ThreadLocal();

    public static int getStreamId() {
        return streamLocal.get();
    }

    private static void setStreamId(int id) {
        streamLocal.set(id);
    }

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.appCtx = appCtx;
    }

    public void connectionOpened(RTMPConnection conn, RTMP state) {
        if (!state.getMode() && this.appCtx != null) {
            ISchedulingService service = (ISchedulingService)this.appCtx.getBean("schedulingService");
            conn.startWaitForHandshake(service);
        }
    }

    public void messageReceived(RTMPConnection conn, ProtocolState state, Object in) throws Exception {
        IRTMPEvent message = null;
        try {
            Packet packet = (Packet)in;
            message = packet.getMessage();
            Header header = packet.getHeader();
            Channel channel = conn.getChannel(header.getChannelId());
            IClientStream stream = conn.getStreamById(header.getStreamId());
            if (log.isDebugEnabled()) {
                log.debug("Message recieved");
                log.debug("Stream Id: " + header);
                log.debug("Channel: " + channel);
            }
            Red5.setConnectionLocal(conn);
            BaseRTMPHandler.setStreamId(header.getStreamId());
            conn.messageReceived();
            message.setSource(conn);
            switch (header.getDataType()) {
                case 1: {
                    this.onChunkSize(conn, channel, header, (ChunkSize)message);
                    break;
                }
                case 17: 
                case 20: {
                    this.onInvoke(conn, channel, header, (Invoke)message, (RTMP)state);
                    if (message.getHeader().getStreamId() == 0 || ((Invoke)message).getCall().getServiceName() != null || !"publish".equals(((Invoke)message).getCall().getServiceMethodName()) || stream == null) break;
                    ((IEventDispatcher)((Object)stream)).dispatchEvent(message);
                    break;
                }
                case 18: {
                    if (((Notify)message).getData() != null && stream != null) {
                        ((IEventDispatcher)((Object)stream)).dispatchEvent(message);
                        break;
                    }
                    this.onInvoke(conn, channel, header, (Notify)message, (RTMP)state);
                    break;
                }
                case 15: {
                    if (stream == null) break;
                    ((IEventDispatcher)((Object)stream)).dispatchEvent(message);
                    break;
                }
                case 4: {
                    this.onPing(conn, channel, header, (Ping)message);
                    break;
                }
                case 3: {
                    this.onStreamBytesRead(conn, channel, header, (BytesRead)message);
                    break;
                }
                case 8: 
                case 9: {
                    if (stream == null) break;
                    ((IEventDispatcher)((Object)stream)).dispatchEvent(message);
                    break;
                }
                case 16: 
                case 19: {
                    this.onSharedObject(conn, channel, header, (SharedObjectMessage)message);
                    break;
                }
                default: {
                    log.debug("Unknown type: {}", (Object)header.getDataType());
                }
            }
            if (message instanceof Unknown) {
                log.info("{}", (Object)message);
            }
        }
        catch (RuntimeException e) {
            log.error("Exception", (Throwable)e);
        }
        if (message != null) {
            message.release();
        }
    }

    public void messageSent(RTMPConnection conn, Object message) {
        if (log.isDebugEnabled()) {
            log.debug("Message sent");
        }
        if (message instanceof ByteBuffer) {
            return;
        }
        conn.messageSent((Packet)message);
        Packet sent = (Packet)message;
        int channelId = sent.getHeader().getChannelId();
        IClientStream stream = conn.getStreamByChannelId(channelId);
        if (stream != null && stream instanceof PlaylistSubscriberStream) {
            ((PlaylistSubscriberStream)stream).written(sent.getMessage());
        }
    }

    public void connectionClosed(RTMPConnection conn, RTMP state) {
        state.setState((byte)4);
        conn.close();
    }

    protected String getHostname(String url) {
        log.debug("url: {}", (Object)url);
        String[] parts = url.split("/");
        if (parts.length == 2) {
            return "";
        }
        return parts[2];
    }

    protected abstract void onChunkSize(RTMPConnection var1, Channel var2, Header var3, ChunkSize var4);

    protected void handlePendingCallResult(RTMPConnection conn, Notify invoke) {
        IServiceCall call = invoke.getCall();
        IPendingServiceCall pendingCall = conn.getPendingCall(invoke.getInvokeId());
        if (pendingCall != null) {
            Set<IPendingServiceCallback> callbacks;
            Object[] args = call.getArguments();
            if (args != null && args.length > 0) {
                pendingCall.setResult(args[0]);
            }
            if (!(callbacks = pendingCall.getCallbacks()).isEmpty()) {
                HashSet<IPendingServiceCallback> tmp = new HashSet<IPendingServiceCallback>();
                tmp.addAll(callbacks);
                for (IPendingServiceCallback callback : tmp) {
                    try {
                        callback.resultReceived(pendingCall);
                    }
                    catch (Exception e) {
                        log.error("Error while executing callback {} {}", (Object)callback, (Object)e);
                    }
                }
            }
        }
    }

    protected abstract void onInvoke(RTMPConnection var1, Channel var2, Header var3, Notify var4, RTMP var5);

    protected abstract void onPing(RTMPConnection var1, Channel var2, Header var3, Ping var4);

    protected void onStreamBytesRead(RTMPConnection conn, Channel channel, Header source, BytesRead streamBytesRead) {
        conn.receivedBytesRead(streamBytesRead.getBytesRead());
    }

    protected abstract void onSharedObject(RTMPConnection var1, Channel var2, Header var3, SharedObjectMessage var4);
}

