/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.IConnection;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.net.mrtmp.IMRTMPConnection;
import org.red5.server.net.mrtmp.IMRTMPManager;
import org.red5.server.net.protocol.ProtocolState;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPHandler;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;

public class EdgeRTMPHandler
extends RTMPHandler {
    private IMRTMPManager mrtmpManager;

    public void setMRTMPManager(IMRTMPManager mrtmpManager) {
        this.mrtmpManager = mrtmpManager;
    }

    public void messageReceived(RTMPConnection conn, ProtocolState state, Object in) throws Exception {
        IRTMPEvent message = null;
        Packet packet = (Packet)in;
        message = packet.getMessage();
        Header header = packet.getHeader();
        Channel channel = conn.getChannel(header.getChannelId());
        conn.messageReceived();
        if (header.getDataType() == 3) {
            this.onStreamBytesRead(conn, channel, header, (BytesRead)message);
        }
        if (header.getDataType() == 20) {
            IPendingServiceCall call = ((Invoke)message).getCall();
            String action = call.getServiceMethodName();
            if (call.getServiceName() == null && !conn.isConnected() && action.equals("connect")) {
                this.handleConnect(conn, channel, header, (Invoke)message, (RTMP)state);
                return;
            }
        }
        switch (header.getDataType()) {
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.forwardPacket(conn, packet);
                break;
            }
            case 4: {
                this.onPing(conn, channel, header, (Ping)message);
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug("Unknown type: " + header.getDataType());
            }
        }
        if (message instanceof Unknown) {
            log.info(message.toString());
        }
        if (message != null) {
            message.release();
        }
    }

    public void messageSent(RTMPConnection conn, Object message) {
        if (log.isDebugEnabled()) {
            log.debug("Message sent");
        }
        if (message instanceof ByteBuffer) {
            return;
        }
        conn.messageSent((Packet)message);
    }

    protected void onPing(RTMPConnection conn, Channel channel, Header source, Ping ping) {
        switch (ping.getValue1()) {
            case 7: {
                conn.pingReceived(ping);
                break;
            }
            default: {
                Packet p = new Packet(source);
                p.setMessage(ping);
                this.forwardPacket(conn, p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleConnect(RTMPConnection conn, Channel channel, Header header, Invoke invoke, RTMP rtmp) {
        String path;
        IPendingServiceCall call = invoke.getCall();
        Map params = invoke.getConnectionParams();
        String host = this.getHostname((String)params.get("tcUrl"));
        if (host.endsWith(":1935")) {
            host = host.substring(0, host.length() - 5);
        }
        if ((path = (String)params.get("app")).indexOf("?") != -1) {
            int idx = path.indexOf("?");
            params.put("queryString", path.substring(idx));
            path = path.substring(0, idx);
        }
        params.put("path", path);
        String sessionId = null;
        conn.setup(host, path, sessionId, params);
        if (!this.checkPermission(conn)) {
            call.setStatus((byte)18);
            if (call instanceof IPendingServiceCall) {
                IPendingServiceCall pc = call;
                pc.setResult(this.getStatus("NetConnection.Connect.Rejected"));
            }
            Invoke reply = new Invoke();
            reply.setCall(call);
            reply.setInvokeId(invoke.getInvokeId());
            channel.write(reply);
            conn.close();
        } else {
            RTMP rTMP = rtmp;
            synchronized (rTMP) {
                this.sendConnectMessage(conn);
                rtmp.setState((byte)17);
                Packet packet = new Packet(header);
                packet.setMessage(invoke);
                this.forwardPacket(conn, packet);
                rtmp.setState((byte)18);
                if (Integer.valueOf(3).equals(params.get("objectEncoding")) && call instanceof IPendingServiceCall) {
                    rtmp.setEncoding(IConnection.Encoding.AMF3);
                }
            }
        }
    }

    protected boolean checkPermission(RTMPConnection conn) {
        return true;
    }

    protected void sendConnectMessage(RTMPConnection conn) {
        IMRTMPConnection mrtmpConn = this.mrtmpManager.lookupMRTMPConnection(conn);
        if (mrtmpConn != null) {
            mrtmpConn.connect(conn.getId());
        }
    }

    protected void forwardPacket(RTMPConnection conn, Packet packet) {
        IMRTMPConnection mrtmpConn = this.mrtmpManager.lookupMRTMPConnection(conn);
        if (mrtmpConn != null) {
            this.mrtmpManager.lookupMRTMPConnection(conn).write(conn.getId(), packet);
        }
    }

    public void connectionClosed(RTMPConnection conn, RTMP state) {
        conn.close();
    }
}

