/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.IoHandler;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.red5.io.object.Deserializer;
import org.red5.io.object.Serializer;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.service.IServiceCapableConnection;
import org.red5.server.api.service.IServiceInvoker;
import org.red5.server.api.so.IClientSharedObject;
import org.red5.server.net.rtmp.BaseRTMPHandler;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.DeferredResult;
import org.red5.server.net.rtmp.IRTMPConnManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.RTMPMinaIoHandler;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.codec.RTMPCodecFactory;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.service.MethodNotFoundException;
import org.red5.server.service.PendingCall;
import org.red5.server.service.ServiceInvoker;
import org.red5.server.so.ClientSharedObject;
import org.red5.server.so.SharedObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTMPClient
extends BaseRTMPHandler {
    protected static Logger log = LoggerFactory.getLogger(RTMPClient.class);
    private RTMPMinaIoHandler ioHandler;
    private Map<String, Object> connectionParams;
    private IPendingServiceCallback connectCallback;
    private Object serviceProvider;
    private IServiceInvoker serviceInvoker = new ServiceInvoker();
    private Map<String, ClientSharedObject> sharedObjects = new HashMap<String, ClientSharedObject>();

    public RTMPClient() {
        RTMPCodecFactory codecFactory = new RTMPCodecFactory();
        codecFactory.setDeserializer(new Deserializer());
        codecFactory.setSerializer(new Serializer());
        codecFactory.init();
        this.ioHandler = new RTMPMinaIoHandler();
        this.ioHandler.setCodecFactory(codecFactory);
        this.ioHandler.setMode(true);
        this.ioHandler.setHandler(this);
        this.ioHandler.setRtmpConnManager(new RTMPClientConnManager());
    }

    public void connect(String server, int port, String application) {
        this.connect(server, port, application, null);
    }

    public void connect(String server, int port, String application, IPendingServiceCallback connectCallback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app", application);
        params.put("tcUrl", "rtmp://" + server + ':' + port + '/' + application);
        this.connect(server, port, params, connectCallback);
    }

    public void connect(String server, int port, Map<String, Object> connectionParams) {
        this.connect(server, port, connectionParams, null);
    }

    public void connect(String server, int port, Map<String, Object> connectionParams, IPendingServiceCallback connectCallback) {
        this.connectionParams = connectionParams;
        if (!connectionParams.containsKey("objectEncoding")) {
            connectionParams.put("objectEncoding", 0.0);
        }
        this.connectCallback = connectCallback;
        SocketConnector connector = new SocketConnector();
        connector.connect((SocketAddress)new InetSocketAddress(server, port), (IoHandler)this.ioHandler);
    }

    public void setServiceProvider(Object serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public synchronized IClientSharedObject getSharedObject(String name, boolean persistent) {
        ClientSharedObject result = this.sharedObjects.get(name);
        if (result != null) {
            if (result.isPersistentObject() != persistent) {
                throw new RuntimeException("Already connected to a shared object with this name, but with different persistence.");
            }
            return result;
        }
        result = new ClientSharedObject(name, persistent);
        this.sharedObjects.put(name, result);
        return result;
    }

    public void invoke(String method, IPendingServiceCallback callback) {
        IConnection conn = Red5.getConnectionLocal();
        if (conn instanceof IServiceCapableConnection) {
            ((IServiceCapableConnection)conn).invoke(method, callback);
        }
    }

    public void invoke(String method, Object[] params, IPendingServiceCallback callback) {
        IConnection conn = Red5.getConnectionLocal();
        if (conn instanceof IServiceCapableConnection) {
            ((IServiceCapableConnection)conn).invoke(method, params, callback);
        }
    }

    @Override
    public void connectionOpened(RTMPConnection conn, RTMP state) {
        Channel channel = conn.getChannel(3);
        PendingCall pendingCall = new PendingCall("connect");
        Invoke invoke = new Invoke(pendingCall);
        invoke.setConnectionParams(this.connectionParams);
        invoke.setInvokeId(conn.getInvokeId());
        if (this.connectCallback != null) {
            pendingCall.registerCallback(this.connectCallback);
        }
        conn.registerPendingCall(invoke.getInvokeId(), pendingCall);
        channel.write(invoke);
    }

    @Override
    protected void onInvoke(RTMPConnection conn, Channel channel, Header source, Notify invoke, RTMP rtmp) {
        IServiceCall call = invoke.getCall();
        if (call.getServiceMethodName().equals("_result") || call.getServiceMethodName().equals("_error")) {
            this.handlePendingCallResult(conn, invoke);
            return;
        }
        if (this.serviceProvider == null) {
            call.setStatus((byte)17);
            call.setException(new MethodNotFoundException(call.getServiceMethodName()));
        } else {
            this.serviceInvoker.invoke(call, this.serviceProvider);
        }
        if (call instanceof IPendingServiceCall) {
            IPendingServiceCall psc = (IPendingServiceCall)call;
            Object result = psc.getResult();
            if (result instanceof DeferredResult) {
                DeferredResult dr = (DeferredResult)result;
                dr.setInvokeId(invoke.getInvokeId());
                dr.setServiceCall(psc);
                dr.setChannel(channel);
                conn.registerDeferredResult(dr);
            } else {
                Invoke reply = new Invoke();
                reply.setCall(call);
                reply.setInvokeId(invoke.getInvokeId());
                channel.write(reply);
            }
        }
    }

    @Override
    protected void onChunkSize(RTMPConnection conn, Channel channel, Header source, ChunkSize chunkSize) {
        log.info("ChunkSize is not implemented yet: " + chunkSize);
    }

    @Override
    protected void onPing(RTMPConnection conn, Channel channel, Header source, Ping ping) {
        switch (ping.getValue1()) {
            case 6: {
                Ping pong = new Ping();
                pong.setValue1((short)7);
                int now = (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL);
                pong.setValue2(now);
                pong.setValue3(-1);
                conn.ping(pong);
                break;
            }
            default: {
                log.warn("Unhandled ping: " + ping);
            }
        }
    }

    @Override
    protected void onSharedObject(RTMPConnection conn, Channel channel, Header source, SharedObjectMessage object) {
        ClientSharedObject so = this.sharedObjects.get(object.getName());
        if (so == null) {
            log.error("Ignoring request for non-existend SO: " + object);
            return;
        }
        if (so.isPersistentObject() != object.isPersistent()) {
            log.error("Ignoring request for wrong-persistent SO: " + object);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Received SO request: " + object);
        }
        so.dispatchEvent(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RTMPClientConnManager
    implements IRTMPConnManager {
        private RTMPClientConnManager() {
        }

        @Override
        public RTMPConnection createConnection(Class connCls) {
            if (connCls != RTMPMinaConnection.class) {
                throw new IllegalArgumentException("Only support RTMPMinaConnection!");
            }
            RTMPMinaConnection conn = new RTMPMinaConnection();
            return conn;
        }

        @Override
        public RTMPConnection getConnection(int clientId) {
            return null;
        }

        @Override
        public RTMPConnection removeConnection(int clientId) {
            return null;
        }

        @Override
        public Collection<RTMPConnection> removeConnections() {
            return null;
        }
    }
}

