/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.net.rtmp.EdgeRTMPMinaConnection;
import org.red5.server.net.rtmp.IRTMPConnManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmpt.RTMPTConnection;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTMPConnManager
implements IRTMPConnManager,
ApplicationContextAware {
    private ConcurrentMap<Integer, RTMPConnection> connMap = new ConcurrentHashMap<Integer, RTMPConnection>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private ApplicationContext appCtx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RTMPConnection createConnection(Class connCls) {
        if (!RTMPConnection.class.isAssignableFrom(connCls)) {
            return null;
        }
        try {
            RTMPConnection conn = this.createConnectionInstance(connCls);
            this.lock.writeLock().lock();
            try {
                int base = conn.hashCode();
                for (int offset = 0; offset >= 0; ++offset) {
                    if (!this.connMap.containsKey(base + offset)) {
                        conn.setId(base + offset);
                        this.connMap.put(base + offset, conn);
                    } else {
                        if (this.connMap.containsKey(base - offset)) continue;
                        conn.setId(base - offset);
                        this.connMap.put(base - offset, conn);
                    }
                    break;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return conn;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RTMPConnection getConnection(int clientId) {
        this.lock.readLock().lock();
        try {
            RTMPConnection rTMPConnection = (RTMPConnection)this.connMap.get(clientId);
            return rTMPConnection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RTMPConnection removeConnection(int clientId) {
        this.lock.writeLock().lock();
        try {
            RTMPConnection rTMPConnection = (RTMPConnection)this.connMap.remove(clientId);
            return rTMPConnection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RTMPConnection> removeConnections() {
        ArrayList<RTMPConnection> list = new ArrayList<RTMPConnection>(this.connMap.size());
        this.lock.writeLock().lock();
        try {
            list.addAll(this.connMap.values());
            ArrayList<RTMPConnection> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.appCtx = appCtx;
    }

    public RTMPConnection createConnectionInstance(Class cls) throws Exception {
        RTMPConnection conn = null;
        conn = cls == RTMPMinaConnection.class ? (RTMPMinaConnection)this.appCtx.getBean("rtmpMinaConnection") : (cls == EdgeRTMPMinaConnection.class ? (EdgeRTMPMinaConnection)this.appCtx.getBean("rtmpEdgeMinaConnection") : (cls == RTMPTConnection.class ? (RTMPTConnection)this.appCtx.getBean("rtmptConnection") : (RTMPConnection)cls.newInstance()));
        conn.setSchedulingService((ISchedulingService)this.appCtx.getBean("schedulingService"));
        return conn;
    }
}

