/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.BaseConnection;
import org.red5.server.api.IBWControllable;
import org.red5.server.api.IBandwidthConfigure;
import org.red5.server.api.IConnection;
import org.red5.server.api.IConnectionBWConfig;
import org.red5.server.api.IContext;
import org.red5.server.api.IScope;
import org.red5.server.api.Red5;
import org.red5.server.api.ScopeUtils;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.service.IServiceCapableConnection;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.api.stream.IPlaylistSubscriberStream;
import org.red5.server.api.stream.ISingleItemSubscriberStream;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.IStreamService;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.DeferredResult;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.ClientBW;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.ServerBW;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.service.Call;
import org.red5.server.service.PendingCall;
import org.red5.server.stream.ClientBroadcastStream;
import org.red5.server.stream.IBWControlContext;
import org.red5.server.stream.IBWControlService;
import org.red5.server.stream.OutputStream;
import org.red5.server.stream.PlaylistSubscriberStream;
import org.red5.server.stream.StreamService;
import org.red5.server.stream.VideoCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RTMPConnection
extends BaseConnection
implements IStreamCapableConnection,
IServiceCapableConnection {
    protected static Logger log = LoggerFactory.getLogger(RTMPConnection.class);
    private static final String VIDEO_CODEC_FACTORY = "videoCodecFactory";
    private ConcurrentMap<Integer, Channel> channels = new ConcurrentHashMap<Integer, Channel>();
    private ConcurrentMap<Integer, IClientStream> streams = new ConcurrentHashMap<Integer, IClientStream>();
    private BitSet reservedStreams = new BitSet();
    protected AtomicInteger invokeId = new AtomicInteger(1);
    protected ConcurrentMap<Integer, IPendingServiceCall> pendingCalls = new ConcurrentHashMap<Integer, IPendingServiceCall>();
    protected HashSet<DeferredResult> deferredResults = new HashSet();
    protected int lastPingTime = -1;
    protected long lastPingSent;
    protected long lastPongReceived;
    protected String keepAliveJobName;
    protected int pingInterval = 5000;
    protected int maxInactivity = 60000;
    private int bytesReadInterval = 122880;
    private long lastBytesRead = 0L;
    private int nextBytesRead = 122880;
    private long clientBytesRead = 0L;
    private IConnectionBWConfig bwConfig;
    private IBWControlContext bwContext;
    private ConcurrentMap<Integer, AtomicInteger> pendingVideos = new ConcurrentHashMap<Integer, AtomicInteger>();
    private int usedStreams;
    protected IConnection.Encoding encoding = IConnection.Encoding.AMF0;
    protected Map<Integer, Integer> streamBuffers = new HashMap<Integer, Integer>();
    protected ObjectName oName;
    private ISchedulingService waitForHandshakeService;
    private String waitForHandshakeJob;
    private int maxHandshakeTimeout = 5000;
    protected int clientId;
    protected RTMP state;
    private ISchedulingService schedulingService;

    public RTMPConnection(String type) {
        super(type, null, null, 0, null, null, null);
    }

    public int getId() {
        return this.clientId;
    }

    public void setId(int clientId) {
        this.clientId = clientId;
    }

    public RTMP getState() {
        return this.state;
    }

    public void setState(RTMP state) {
        this.state = state;
    }

    @Override
    public boolean connect(IScope newScope, Object[] params) {
        boolean success = super.connect(newScope, params);
        if (success) {
            if (this.getScope() != null && this.getScope().getContext() != null) {
                IBWControlService bwController = (IBWControlService)this.getScope().getContext().getBean("BWControlService");
                this.bwContext = bwController.registerBWControllable(this);
            }
            if (this.waitForHandshakeJob != null) {
                this.waitForHandshakeService.removeScheduledJob(this.waitForHandshakeJob);
                this.waitForHandshakeJob = null;
                this.waitForHandshakeService = null;
            }
        }
        return success;
    }

    public void setup(String host, String path, String sessionId, Map<String, Object> params) {
        this.host = host;
        this.path = path;
        this.sessionId = sessionId;
        this.params = params;
        if (params.get("objectEncoding") == Integer.valueOf(3)) {
            this.encoding = IConnection.Encoding.AMF3;
        }
    }

    @Override
    public IConnection.Encoding getEncoding() {
        return this.encoding;
    }

    public synchronized int getNextAvailableChannelId() {
        int result = 4;
        while (this.isChannelUsed(result)) {
            ++result;
        }
        return result;
    }

    public boolean isChannelUsed(int channelId) {
        return this.channels.get(channelId) != null;
    }

    public Channel getChannel(int channelId) {
        Channel value = new Channel(this, channelId);
        Channel result = this.channels.putIfAbsent(channelId, value);
        if (result == null) {
            result = value;
        }
        return result;
    }

    public void closeChannel(int channelId) {
        this.channels.remove(channelId);
    }

    protected Collection<IClientStream> getStreams() {
        return this.streams.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reserveStreamId() {
        int result = -1;
        BitSet bitSet = this.reservedStreams;
        synchronized (bitSet) {
            int i = 0;
            while (true) {
                if (!this.reservedStreams.get(i)) break;
                ++i;
            }
            this.reservedStreams.set(i);
            result = i;
        }
        return result + 1;
    }

    public OutputStream createOutputStream(int streamId) {
        int channelId = 4 + (streamId - 1) * 5;
        Channel data = this.getChannel(channelId++);
        Channel video = this.getChannel(channelId++);
        Channel audio = this.getChannel(channelId++);
        return new OutputStream(video, audio, data);
    }

    public VideoCodecFactory getVideoCodecFactory() {
        IContext context = this.scope.getContext();
        ApplicationContext appCtx = context.getApplicationContext();
        if (!appCtx.containsBean(VIDEO_CODEC_FACTORY)) {
            return null;
        }
        return (VideoCodecFactory)appCtx.getBean(VIDEO_CODEC_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClientBroadcastStream newBroadcastStream(int streamId) {
        if (!this.reservedStreams.get(streamId - 1)) {
            return null;
        }
        ConcurrentMap<Integer, IClientStream> concurrentMap = this.streams;
        synchronized (concurrentMap) {
            if (this.streams.get(streamId - 1) != null) {
                return null;
            }
            ClientBroadcastStream cbs = (ClientBroadcastStream)this.scope.getContext().getBean("clientBroadcastStream");
            Integer buffer = this.streamBuffers.get(streamId - 1);
            if (buffer != null) {
                cbs.setClientBufferDuration(buffer);
            }
            cbs.setStreamId(streamId);
            cbs.setConnection(this);
            cbs.setName(this.createStreamName());
            cbs.setScope(this.getScope());
            this.registerStream(cbs);
            ++this.usedStreams;
            return cbs;
        }
    }

    @Override
    public ISingleItemSubscriberStream newSingleItemSubscriberStream(int streamId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlaylistSubscriberStream newPlaylistSubscriberStream(int streamId) {
        if (!this.reservedStreams.get(streamId - 1)) {
            return null;
        }
        ConcurrentMap<Integer, IClientStream> concurrentMap = this.streams;
        synchronized (concurrentMap) {
            if (this.streams.get(streamId - 1) != null) {
                return null;
            }
            PlaylistSubscriberStream pss = (PlaylistSubscriberStream)this.scope.getContext().getBean("playlistSubscriberStream");
            Integer buffer = this.streamBuffers.get(streamId - 1);
            if (buffer != null) {
                pss.setClientBufferDuration(buffer);
            }
            pss.setName(this.createStreamName());
            pss.setConnection(this);
            pss.setScope(this.getScope());
            pss.setStreamId(streamId);
            this.registerStream(pss);
            ++this.usedStreams;
            return pss;
        }
    }

    protected int getUsedStreamCount() {
        return this.usedStreams;
    }

    @Override
    public IClientStream getStreamById(int id) {
        if (id <= 0) {
            return null;
        }
        return (IClientStream)this.streams.get(id - 1);
    }

    public int getStreamIdForChannel(int channelId) {
        if (channelId < 4) {
            return 0;
        }
        return (channelId - 4) / 5 + 1;
    }

    public IClientStream getStreamByChannelId(int channelId) {
        if (channelId < 4) {
            return null;
        }
        return (IClientStream)this.streams.get(this.getStreamIdForChannel(channelId) - 1);
    }

    protected void registerStream(IClientStream stream) {
        this.streams.put(stream.getStreamId() - 1, stream);
    }

    protected void unregisterStream(IClientStream stream) {
        this.streams.remove(stream.getStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.keepAliveJobName != null) {
            this.schedulingService.removeScheduledJob(this.keepAliveJobName);
            this.keepAliveJobName = null;
        }
        Red5.setConnectionLocal(this);
        IStreamService streamService = (IStreamService)ScopeUtils.getScopeService((IScope)this.scope, IStreamService.class, StreamService.class);
        if (streamService != null) {
            ConcurrentMap<Integer, IClientStream> concurrentMap = this.streams;
            synchronized (concurrentMap) {
                for (Map.Entry entry : this.streams.entrySet()) {
                    IClientStream stream = (IClientStream)entry.getValue();
                    if (stream == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Closing stream: {}", (Object)stream.getStreamId());
                    }
                    streamService.deleteStream(this, stream.getStreamId());
                    --this.usedStreams;
                }
                this.streams.clear();
            }
        }
        this.channels.clear();
        if (this.bwContext != null && this.getScope() != null && this.getScope().getContext() != null) {
            IBWControlService bwController = (IBWControlService)this.getScope().getContext().getBean("BWControlService");
            bwController.unregisterBWControllable(this.bwContext);
            this.bwContext = null;
        }
        super.close();
    }

    @Override
    public void unreserveStreamId(int streamId) {
        this.deleteStreamById(streamId);
        if (streamId > 0) {
            this.reservedStreams.clear(streamId - 1);
        }
    }

    @Override
    public void deleteStreamById(int streamId) {
        if (streamId > 0 && this.streams.get(streamId - 1) != null) {
            this.pendingVideos.remove(streamId);
            --this.usedStreams;
            this.streams.remove(streamId - 1);
            this.streamBuffers.remove(streamId - 1);
        }
    }

    public void ping(Ping ping) {
        this.getChannel(2).write(ping);
    }

    public abstract void rawWrite(ByteBuffer var1);

    public abstract void write(Packet var1);

    protected void updateBytesRead() {
        long bytesRead = this.getReadBytes();
        if (bytesRead >= (long)this.nextBytesRead) {
            BytesRead sbr = new BytesRead((int)bytesRead);
            this.getChannel(2).write(sbr);
            this.nextBytesRead += this.bytesReadInterval;
        }
    }

    public void receivedBytesRead(int bytes) {
        log.info("Client received {} bytes, written {} bytes, {} messages pending", new Object[]{bytes, this.getWrittenBytes(), this.getPendingMessages()});
        this.clientBytesRead = bytes;
    }

    @Override
    public long getClientBytesRead() {
        return this.clientBytesRead;
    }

    @Override
    public void invoke(IServiceCall call) {
        this.invoke(call, 3);
    }

    protected int getInvokeId() {
        return this.invokeId.incrementAndGet();
    }

    protected void registerPendingCall(int invokeId, IPendingServiceCall call) {
        this.pendingCalls.put(invokeId, call);
    }

    @Override
    public void invoke(IServiceCall call, int channel) {
        Invoke invoke = new Invoke();
        invoke.setCall(call);
        invoke.setInvokeId(this.getInvokeId());
        if (call instanceof IPendingServiceCall) {
            this.registerPendingCall(invoke.getInvokeId(), (IPendingServiceCall)call);
        }
        this.getChannel(channel).write(invoke);
    }

    @Override
    public void invoke(String method) {
        this.invoke(method, null, null);
    }

    @Override
    public void invoke(String method, Object[] params) {
        this.invoke(method, params, null);
    }

    @Override
    public void invoke(String method, IPendingServiceCallback callback) {
        this.invoke(method, null, callback);
    }

    @Override
    public void invoke(String method, Object[] params, IPendingServiceCallback callback) {
        PendingCall call = new PendingCall(method, params);
        if (callback != null) {
            call.registerCallback(callback);
        }
        this.invoke(call);
    }

    @Override
    public void notify(IServiceCall call) {
        this.notify(call, 3);
    }

    @Override
    public void notify(IServiceCall call, int channel) {
        Notify notify = new Notify();
        notify.setCall(call);
        this.getChannel(channel).write(notify);
    }

    @Override
    public void notify(String method) {
        this.notify(method, null);
    }

    @Override
    public void notify(String method, Object[] params) {
        Call call = new Call(method, params);
        this.notify(call);
    }

    @Override
    public IBandwidthConfigure getBandwidthConfigure() {
        return this.bwConfig;
    }

    @Override
    public IBWControllable getParentBWControllable() {
        return null;
    }

    @Override
    public void setBandwidthConfigure(IBandwidthConfigure config) {
        if (!(config instanceof IConnectionBWConfig)) {
            return;
        }
        this.bwConfig = (IConnectionBWConfig)config;
        if (this.bwConfig.getDownstreamBandwidth() > 0L) {
            ServerBW serverBW = new ServerBW((int)this.bwConfig.getDownstreamBandwidth() / 8);
            this.getChannel(2).write(serverBW);
        }
        if (this.bwConfig.getUpstreamBandwidth() > 0L) {
            ClientBW clientBW = new ClientBW((int)this.bwConfig.getUpstreamBandwidth() / 8, 0);
            this.getChannel(2).write(clientBW);
            this.bytesReadInterval = (int)this.bwConfig.getUpstreamBandwidth() / 8;
            this.nextBytesRead = (int)this.getWrittenBytes();
        }
        if (this.bwContext != null) {
            IBWControlService bwController = (IBWControlService)this.getScope().getContext().getBean("BWControlService");
            bwController.updateBWConfigure(this.bwContext);
        }
    }

    @Override
    public long getReadBytes() {
        return 0L;
    }

    @Override
    public long getWrittenBytes() {
        return 0L;
    }

    protected IPendingServiceCall getPendingCall(int invokeId) {
        return (IPendingServiceCall)this.pendingCalls.remove(invokeId);
    }

    protected String createStreamName() {
        return UUID.randomUUID().toString();
    }

    protected void writingMessage(Packet message) {
        if (message.getMessage() instanceof VideoData) {
            int streamId = message.getHeader().getStreamId();
            AtomicInteger value = new AtomicInteger();
            AtomicInteger old = this.pendingVideos.putIfAbsent(streamId, value);
            if (old == null) {
                old = value;
            }
            old.incrementAndGet();
        }
    }

    protected void messageReceived() {
        ++this.readMessages;
        this.updateBytesRead();
    }

    protected void messageSent(Packet message) {
        int streamId;
        AtomicInteger pending;
        if (message.getMessage() instanceof VideoData && (pending = (AtomicInteger)this.pendingVideos.get(streamId = message.getHeader().getStreamId())) != null) {
            pending.decrementAndGet();
        }
        ++this.writtenMessages;
    }

    protected void messageDropped() {
        ++this.droppedMessages;
    }

    @Override
    public long getPendingVideoMessages(int streamId) {
        AtomicInteger count = (AtomicInteger)this.pendingVideos.get(streamId);
        long result = count != null ? count.intValue() - this.getUsedStreamCount() : 0;
        return result > 0L ? result : 0L;
    }

    @Override
    public void ping() {
        long newPingTime = System.currentTimeMillis();
        if (this.lastPingSent == 0L) {
            this.lastPongReceived = newPingTime;
        }
        Ping pingRequest = new Ping();
        pingRequest.setValue1((short)6);
        this.lastPingSent = newPingTime;
        int now = (int)(this.lastPingSent & 0xFFFFFFFFFFFFFFFFL);
        pingRequest.setValue2(now);
        pingRequest.setValue3(-1);
        this.ping(pingRequest);
    }

    protected void pingReceived(Ping pong) {
        this.lastPongReceived = System.currentTimeMillis();
        int now = (int)(this.lastPongReceived & 0xFFFFFFFFFFFFFFFFL);
        this.lastPingTime = now - pong.getValue2();
    }

    @Override
    public int getLastPingTime() {
        return this.lastPingTime;
    }

    public void setPingInterval(int pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void setMaxInactivity(int maxInactivity) {
        this.maxInactivity = maxInactivity;
    }

    public void startRoundTripMeasurement() {
        if (this.pingInterval <= 0) {
            return;
        }
        if (this.keepAliveJobName == null) {
            this.keepAliveJobName = this.schedulingService.addScheduledJob(this.pingInterval, new KeepAliveJob());
        }
        log.debug("Keep alive job name {}", (Object)this.keepAliveJobName);
    }

    public void setSchedulingService(ISchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    protected abstract void onInactive();

    public String toString() {
        Object[] args = new Object[]{this.getClass().getSimpleName(), this.getRemoteAddress(), this.getRemotePort(), this.getHost(), this.getReadBytes(), this.getWrittenBytes()};
        return String.format("%1$s from %2$s : %3$s to %4$s (in: %5$s out %6$s )", args);
    }

    protected void registerDeferredResult(DeferredResult result) {
        this.deferredResults.add(result);
    }

    protected void unregisterDeferredResult(DeferredResult result) {
        this.deferredResults.remove(result);
    }

    protected void rememberStreamBufferDuration(int streamId, int bufferDuration) {
        this.streamBuffers.put(streamId - 1, bufferDuration);
    }

    public void setMaxHandshakeTimeout(int maxHandshakeTimeout) {
        this.maxHandshakeTimeout = maxHandshakeTimeout;
    }

    protected void startWaitForHandshake(ISchedulingService service) {
        this.waitForHandshakeService = service;
        this.waitForHandshakeJob = service.addScheduledOnceJob(this.maxHandshakeTimeout, (IScheduledJob)new WaitForHandshakeJob());
    }

    private class WaitForHandshakeJob
    implements IScheduledJob {
        private WaitForHandshakeJob() {
        }

        public void execute(ISchedulingService service) {
            RTMPConnection.this.waitForHandshakeJob = null;
            RTMPConnection.this.waitForHandshakeService = null;
            RTMPConnection.this.onInactive();
        }
    }

    private class KeepAliveJob
    implements IScheduledJob {
        private KeepAliveJob() {
        }

        public void execute(ISchedulingService service) {
            long thisRead = RTMPConnection.this.getReadBytes();
            if (thisRead > RTMPConnection.this.lastBytesRead) {
                RTMPConnection.this.lastBytesRead = thisRead;
                return;
            }
            if (RTMPConnection.this.lastPongReceived > 0L && RTMPConnection.this.lastPingSent - RTMPConnection.this.lastPongReceived > (long)RTMPConnection.this.maxInactivity) {
                log.debug("Keep alive job name {}", (Object)RTMPConnection.this.keepAliveJobName);
                if (log.isDebugEnabled()) {
                    log.debug("Scheduled job list");
                    for (String jobName : service.getScheduledJobNames()) {
                        log.debug("Job: {}", (Object)jobName);
                    }
                }
                service.removeScheduledJob(RTMPConnection.this.keepAliveJobName);
                RTMPConnection.this.keepAliveJobName = null;
                log.warn("Closing {} due to too much inactivity ({}).", (Object)RTMPConnection.this, (Object)(RTMPConnection.this.lastPingSent - RTMPConnection.this.lastPongReceived));
                RTMPConnection.this.onInactive();
                return;
            }
            RTMPConnection.this.ping();
        }
    }
}

