/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.red5.server.api.IScope;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.jmx.JMXFactory;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPMinaConnectionMBean;
import org.red5.server.net.rtmp.message.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPMinaConnection
extends RTMPConnection
implements RTMPMinaConnectionMBean {
    protected static Logger log = LoggerFactory.getLogger(RTMPMinaConnection.class);
    private IoSession ioSession;

    public RTMPMinaConnection() {
        super("persistent");
    }

    public void close() {
        super.close();
        if (this.ioSession != null) {
            this.ioSession.close();
        }
        try {
            JMXAgent.unregisterMBean(this.oName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean connect(IScope newScope, Object[] params) {
        boolean success = super.connect(newScope, params);
        if (!success) {
            return false;
        }
        String hostStr = this.host;
        int port = 1935;
        if (this.host != null && this.host.indexOf(":") > -1) {
            String[] arr = this.host.split(":");
            hostStr = arr[0];
            port = Integer.parseInt(arr[1]);
        }
        try {
            if (this.client != null) {
                this.oName = JMXFactory.createObjectName("type", "RTMPMinaConnection", "connectionType", this.type, "host", hostStr, "port", port + "", "clientId", this.client.getId());
                JMXAgent.registerMBean((Object)this, this.getClass().getName(), RTMPMinaConnectionMBean.class, this.oName);
            } else {
                log.warn("Client was null");
            }
        }
        catch (Exception e) {
            log.warn("Exception registering mbean", (Throwable)e);
        }
        return success;
    }

    public IoSession getIoSession() {
        return this.ioSession;
    }

    public long getPendingMessages() {
        if (this.ioSession == null) {
            return 0L;
        }
        return this.ioSession.getScheduledWriteRequests();
    }

    public long getReadBytes() {
        if (this.ioSession == null) {
            return 0L;
        }
        return this.ioSession.getReadBytes();
    }

    public long getWrittenBytes() {
        if (this.ioSession == null) {
            return 0L;
        }
        return this.ioSession.getWrittenBytes();
    }

    public void invokeMethod(String method) {
        this.invoke(method);
    }

    public boolean isConnected() {
        return super.isConnected() && this.ioSession != null && this.ioSession.isConnected();
    }

    protected void onInactive() {
        this.close();
    }

    public void rawWrite(ByteBuffer out) {
        if (this.ioSession != null) {
            this.ioSession.write((Object)out);
        }
    }

    void setIoSession(IoSession protocolSession) {
        SocketAddress remote = protocolSession.getRemoteAddress();
        if (remote instanceof InetSocketAddress) {
            this.remoteAddress = ((InetSocketAddress)remote).getAddress().getHostAddress();
            this.remotePort = ((InetSocketAddress)remote).getPort();
        } else {
            this.remoteAddress = remote.toString();
            this.remotePort = -1;
        }
        this.remoteAddresses = new ArrayList();
        this.remoteAddresses.add(this.remoteAddress);
        this.remoteAddresses = Collections.unmodifiableList(this.remoteAddresses);
        this.ioSession = protocolSession;
    }

    public void write(Packet out) {
        if (this.ioSession != null) {
            this.writingMessage(out);
            this.ioSession.write((Object)out);
        }
    }
}

