/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.red5.server.net.protocol.ProtocolState;
import org.red5.server.net.rtmp.IRTMPConnManager;
import org.red5.server.net.rtmp.IRTMPHandler;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RTMPMinaIoHandler
extends IoHandlerAdapter
implements ApplicationContextAware {
    protected static Logger log = LoggerFactory.getLogger(RTMPMinaIoHandler.class);
    protected IRTMPHandler handler;
    protected boolean mode = false;
    protected ApplicationContext appCtx;
    private ProtocolCodecFactory codecFactory = null;
    private IRTMPConnManager rtmpConnManager;

    public void setHandler(IRTMPHandler handler) {
        this.handler = handler;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }

    public void setCodecFactory(ProtocolCodecFactory codecFactory) {
        this.codecFactory = codecFactory;
    }

    public void setRtmpConnManager(IRTMPConnManager rtmpConnManager) {
        this.rtmpConnManager = rtmpConnManager;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        log.debug("Exception caught {}", cause);
    }

    public void messageReceived(IoSession session, Object in) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("messageRecieved");
        }
        ProtocolState state = (ProtocolState)session.getAttribute("protocol_state");
        if (in instanceof ByteBuffer) {
            this.rawBufferRecieved(state, (ByteBuffer)in, session);
            return;
        }
        RTMPMinaConnection conn = (RTMPMinaConnection)session.getAttachment();
        this.handler.messageReceived(conn, state, in);
    }

    protected void rawBufferRecieved(ProtocolState state, ByteBuffer in, IoSession session) {
        RTMP rtmp = (RTMP)state;
        if (!rtmp.getMode()) {
            if (rtmp.getState() != 1) {
                log.warn("Raw buffer after handshake, something odd going on");
            }
            log.debug("Handshake 2nd phase - size: {}", (Object)in.remaining());
            ByteBuffer out = ByteBuffer.allocate((int)3073);
            out.put((byte)3);
            out.putInt(1);
            out.fill((byte)0, 1532);
            out.put(in);
            out.flip();
            rtmp.setHandshake(out, 9, 1528);
            session.write((Object)out);
        } else {
            log.debug("Handshake 3d phase - size: {}", (Object)in.remaining());
            in.skip(1);
            ByteBuffer out = ByteBuffer.allocate((int)1536);
            int limit = in.limit();
            in.limit(in.position() + 1536);
            out.put(in);
            out.flip();
            in.limit(limit);
            in.skip(1536);
            session.write((Object)out);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("messageSent");
        }
        session.getAttribute("protocol_state");
        RTMPMinaConnection conn = (RTMPMinaConnection)session.getAttachment();
        this.handler.messageSent(conn, message);
        if (this.mode && message instanceof ByteBuffer && ((ByteBuffer)message).limit() == 1536) {
            this.handler.connectionOpened((RTMPMinaConnection)session.getAttachment(), (RTMP)session.getAttribute("protocol_state"));
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        super.sessionOpened(session);
        RTMP rtmp = (RTMP)session.getAttribute("protocol_state");
        if (rtmp.getMode()) {
            if (log.isDebugEnabled()) {
                log.debug("Handshake 1st phase");
            }
            ByteBuffer out = ByteBuffer.allocate((int)1537);
            out.put((byte)3);
            out.fill((byte)0, 1536);
            out.flip();
            session.write((Object)out);
        } else {
            RTMPMinaConnection conn = (RTMPMinaConnection)session.getAttachment();
            this.handler.connectionOpened(conn, rtmp);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        ByteBuffer buf = (ByteBuffer)session.getAttribute("buffer");
        if (buf != null) {
            buf.release();
        }
        RTMP rtmp = (RTMP)session.getAttribute("protocol_state");
        RTMPMinaConnection conn = (RTMPMinaConnection)session.getAttachment();
        this.handler.connectionClosed(conn, rtmp);
        session.removeAttribute("protocol_state");
        session.setAttachment(null);
    }

    public void sessionCreated(IoSession session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Session created");
        }
        RTMP rtmp = new RTMP(this.mode);
        session.setAttribute("protocol_state", (Object)rtmp);
        session.getFilterChain().addFirst("protocolFilter", (IoFilter)new ProtocolCodecFilter(this.codecFactory));
        if (log.isDebugEnabled()) {
            session.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        RTMPMinaConnection conn = this.createRTMPMinaConnection();
        conn.setIoSession(session);
        conn.setState(rtmp);
        session.setAttachment((Object)conn);
    }

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.appCtx = appCtx;
    }

    protected RTMPMinaConnection createRTMPMinaConnection() {
        return (RTMPMinaConnection)this.rtmpConnManager.createConnection(RTMPMinaConnection.class);
    }
}

