/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoService;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.integration.jmx.IoServiceManager;
import org.apache.mina.integration.jmx.IoServiceManagerMBean;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.red5.server.jmx.JMXAgent;
import org.red5.server.jmx.JMXFactory;
import org.red5.server.net.rtmp.RTMPMinaIoHandler;
import org.red5.server.net.rtmp.RTMPMinaTransportMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTMPMinaTransport
implements RTMPMinaTransportMBean {
    private static final int DEFAULT_EVENT_THREADS_CORE = 16;
    private static final int DEFAULT_EVENT_THREADS_KEEPALIVE = 60;
    private static final int DEFAULT_EVENT_THREADS_MAX = 32;
    private static final int DEFAULT_EVENT_THREADS_QUEUE = -1;
    private static final int DEFAULT_IO_THREADS = Runtime.getRuntime().availableProcessors() + 1;
    private static final int DEFAULT_PORT = 1935;
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE = 262144;
    private static final int DEFAULT_SEND_BUFFER_SIZE = 65536;
    private static final boolean DEFAULT_TCP_NO_DELAY = false;
    private static final boolean DEFAULT_USE_HEAP_BUFFERS = true;
    private static final Logger log = LoggerFactory.getLogger(RTMPMinaTransport.class);
    private SocketAcceptor acceptor;
    private String address = null;
    private ExecutorService eventExecutor;
    private int eventThreadsCore = 16;
    private int eventThreadsKeepalive = 60;
    private int eventThreadsMax = 32;
    private int eventThreadsQueue = -1;
    private IoHandlerAdapter ioHandler;
    private IoServiceManager serviceManager;
    private int ioThreads = DEFAULT_IO_THREADS;
    private boolean isLoggingTraffic = false;
    private ObjectName oName;
    private ObjectName serviceManagerObjectName;
    private int jmxPollInterval = 1000;
    private int port = 1935;
    private int receiveBufferSize = 262144;
    private int sendBufferSize = 65536;
    private boolean tcpNoDelay = false;
    private boolean useHeapBuffers = true;

    private void initIOHandler() {
        if (this.ioHandler == null) {
            log.info("No RTMP IO Handler associated - using defaults");
            this.ioHandler = new RTMPMinaIoHandler();
        }
    }

    @Override
    public void setAddress(String address) {
        if ("*".equals(address) || "0.0.0.0".equals(address)) {
            address = null;
        }
        this.address = address;
        JMXAgent.updateMBeanAttribute(this.oName, "address", address == null ? "0.0.0.0" : address);
    }

    @Override
    public void setEventThreadsCore(int eventThreadsCore) {
        this.eventThreadsCore = eventThreadsCore;
    }

    @Override
    public void setEventThreadsKeepalive(int eventThreadsKeepalive) {
        this.eventThreadsKeepalive = eventThreadsKeepalive;
    }

    @Override
    public void setEventThreadsMax(int eventThreadsMax) {
        this.eventThreadsMax = eventThreadsMax;
    }

    @Override
    public void setEventThreadsQueue(int eventThreadsQueue) {
        this.eventThreadsQueue = eventThreadsQueue;
    }

    @Override
    public void setIoHandler(IoHandlerAdapter rtmpIOHandler) {
        this.ioHandler = rtmpIOHandler;
    }

    @Override
    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    @Override
    public void setIsLoggingTraffic(boolean isLoggingTraffic) {
        this.isLoggingTraffic = isLoggingTraffic;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
        JMXAgent.updateMBeanAttribute(this.oName, "port", port);
    }

    @Override
    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    @Override
    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    @Override
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    @Override
    public void setUseHeapBuffers(boolean useHeapBuffers) {
        this.useHeapBuffers = useHeapBuffers;
    }

    @Override
    public void start() throws Exception {
        this.initIOHandler();
        ByteBuffer.setUseDirectBuffers((!this.useHeapBuffers ? 1 : 0) != 0);
        if (this.useHeapBuffers) {
            ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        }
        log.info("RTMP Mina Transport Settings");
        log.info("IO Threads: {}", (Object)this.ioThreads);
        log.info("Event Threads - core: {}, max: {}, queue: {}, keepalive: {}", new Object[]{this.eventThreadsCore, this.eventThreadsMax, this.eventThreadsQueue, this.eventThreadsKeepalive});
        this.eventExecutor = new ThreadPoolExecutor(this.eventThreadsCore, this.eventThreadsMax, this.eventThreadsKeepalive, TimeUnit.SECONDS, this.threadQueue(this.eventThreadsQueue));
        ((ThreadPoolExecutor)this.eventExecutor).setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        this.acceptor = new SocketAcceptor(this.ioThreads, (Executor)Executors.newCachedThreadPool());
        this.acceptor.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.eventExecutor));
        SocketAcceptorConfig config = this.acceptor.getDefaultConfig();
        config.setThreadModel(ThreadModel.MANUAL);
        config.setReuseAddress(true);
        config.setBacklog(100);
        log.info("TCP No Delay: {}", (Object)this.tcpNoDelay);
        log.info("Receive Buffer Size: {}", (Object)this.receiveBufferSize);
        log.info("Send Buffer Size: {}", (Object)this.sendBufferSize);
        SocketSessionConfig sessionConf = config.getSessionConfig();
        sessionConf.setReuseAddress(true);
        sessionConf.setTcpNoDelay(this.tcpNoDelay);
        sessionConf.setReceiveBufferSize(this.receiveBufferSize);
        sessionConf.setSendBufferSize(this.sendBufferSize);
        if (this.isLoggingTraffic) {
            log.info("Configuring traffic logging filter");
            this.acceptor.getFilterChain().addFirst("LoggingFilter", (IoFilter)new LoggingFilter());
        }
        InetSocketAddress socketAddress = this.address == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.address, this.port);
        this.acceptor.bind((SocketAddress)socketAddress, (IoHandler)this.ioHandler);
        log.info("RTMP Mina Transport bound to {}", (Object)((Object)socketAddress).toString());
        this.oName = JMXFactory.createObjectName("type", "RTMPMinaTransport", "address", this.address == null ? "0.0.0.0" : this.address, "port", this.port + "");
        JMXAgent.registerMBean((Object)this, this.getClass().getName(), RTMPMinaTransportMBean.class, this.oName);
        if (JMXAgent.isEnableMinaMonitor()) {
            this.serviceManager = new IoServiceManager((IoService)this.acceptor);
            this.serviceManager.startCollectingStats(this.jmxPollInterval);
            this.serviceManagerObjectName = JMXFactory.createObjectName("type", "IoServiceManager", "address", this.address == null ? "0.0.0.0" : this.address, "port", this.port + "");
            JMXAgent.registerMBean((Object)this.serviceManager, this.serviceManager.getClass().getName(), IoServiceManagerMBean.class, this.serviceManagerObjectName);
        }
    }

    @Override
    public void stop() {
        log.info("RTMP Mina Transport unbind");
        this.acceptor.unbindAll();
        this.eventExecutor.shutdown();
        JMXAgent.unregisterMBean(this.oName);
        if (this.serviceManagerObjectName != null) {
            if (this.serviceManager != null) {
                this.serviceManager.stopCollectingStats();
                this.serviceManager.closeAllSessions();
            }
            JMXAgent.unregisterMBean(this.serviceManagerObjectName);
        }
    }

    private BlockingQueue<Runnable> threadQueue(int size) {
        switch (size) {
            case -1: {
                return new LinkedBlockingQueue<Runnable>();
            }
            case 0: {
                return new SynchronousQueue<Runnable>();
            }
        }
        return new ArrayBlockingQueue<Runnable>(size);
    }

    public String toString() {
        return "RTMP Mina Transport [port=" + this.port + "]";
    }

    public int getJmxPollInterval() {
        return this.jmxPollInterval;
    }

    public void setJmxPollInterval(int jmxPollInterval) {
        this.jmxPollInterval = jmxPollInterval;
    }
}

