/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.net.mrtmp.IMRTMPConnection;
import org.red5.server.net.mrtmp.IMRTMPOriginManager;
import org.red5.server.net.mrtmp.OriginMRTMPHandler;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.message.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPOriginConnection
extends RTMPConnection {
    private static final Logger log = LoggerFactory.getLogger(RTMPOriginConnection.class);
    private int ioSessionId;
    private IMRTMPOriginManager mrtmpManager;
    private OriginMRTMPHandler handler;
    private RTMP state;

    public RTMPOriginConnection(String type, int clientId) {
        this(type, clientId, 0);
    }

    public RTMPOriginConnection(String type, int clientId, int ioSessionId) {
        super(type);
        this.setId(clientId);
        this.ioSessionId = ioSessionId;
        this.state = new RTMP(false);
        this.state.setState((byte)2);
    }

    public int getIoSessionId() {
        return this.ioSessionId;
    }

    public void setMrtmpManager(IMRTMPOriginManager mrtmpManager) {
        this.mrtmpManager = mrtmpManager;
    }

    public void setHandler(OriginMRTMPHandler handler) {
        this.handler = handler;
    }

    public RTMP getState() {
        return this.state;
    }

    protected void onInactive() {
    }

    public void rawWrite(ByteBuffer out) {
        log.warn("Erhhh... Raw write. Shouldn't be in here!");
    }

    public void write(Packet packet) {
        IMRTMPConnection conn = this.mrtmpManager.lookupMRTMPConnection(this);
        if (conn == null) {
            log.debug("Client " + this.getId() + " is gone!");
            return;
        }
        if (!this.type.equals("persistent")) {
            this.mrtmpManager.associate(this, conn);
        }
        log.debug("Origin writing packet to client " + this.getId() + ":" + packet.getMessage());
        conn.write(this.getId(), packet);
    }

    public void startRoundTripMeasurement() {
    }

    protected void startWaitForHandshake(ISchedulingService service) {
    }

    public synchronized void close() {
        if (this.state.getState() == 4) {
            return;
        }
        IMRTMPConnection conn = this.mrtmpManager.lookupMRTMPConnection(this);
        if (conn != null) {
            conn.disconnect(this.getId());
        }
        this.handler.closeConnection(this);
    }

    public synchronized void realClose() {
        if (this.state.getState() != 4) {
            this.state.setState((byte)4);
            super.close();
        }
    }
}

