/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import org.apache.mina.common.ByteBuffer;
import org.red5.server.net.rtmp.message.Constants;

public class RTMPUtils
implements Constants {
    public static void writeReverseIntOld(ByteBuffer out, int value) {
        byte[] bytes = new byte[4];
        ByteBuffer rev = ByteBuffer.allocate((int)4);
        rev.putInt(value);
        rev.flip();
        bytes[3] = rev.get();
        bytes[2] = rev.get();
        bytes[1] = rev.get();
        bytes[0] = rev.get();
        out.put(bytes);
        rev.release();
        rev = null;
    }

    public static void writeReverseInt(ByteBuffer out, int value) {
        out.put((byte)(0xFF & value));
        out.put((byte)(0xFF & value >> 8));
        out.put((byte)(0xFF & value >> 16));
        out.put((byte)(0xFF & value >> 24));
    }

    public static void writeMediumInt(ByteBuffer out, int value) {
        out.put((byte)(0xFF & value >> 16));
        out.put((byte)(0xFF & value >> 8));
        out.put((byte)(0xFF & value >> 0));
    }

    public static int readUnsignedMediumInt(ByteBuffer in) {
        byte a = in.get();
        byte b = in.get();
        byte c = in.get();
        int val = 0;
        val = a < 0 ? (val += a + 256 << 16) : (val += a << 16);
        val = b < 0 ? (val += b + 256 << 8) : (val += b << 8);
        val = c < 0 ? (val += c + 256) : (val += c);
        return val;
    }

    public static int readUnsignedMediumIntOld(ByteBuffer in) {
        byte[] bytes = new byte[3];
        in.get(bytes);
        int val = 0;
        val += (bytes[0] & 0xFF) * 256 * 256;
        val += (bytes[1] & 0xFF) * 256;
        return val += bytes[2] & 0xFF;
    }

    public static int readMediumIntOld(ByteBuffer in) {
        ByteBuffer buf = ByteBuffer.allocate((int)4);
        buf.put((byte)0);
        buf.put(in.get());
        buf.put(in.get());
        buf.put(in.get());
        buf.flip();
        int value = buf.getInt();
        buf.release();
        buf = null;
        return value;
    }

    public static int readMediumInt(ByteBuffer in) {
        byte a = in.get();
        byte b = in.get();
        byte c = in.get();
        int val = 0;
        val = a < 0 ? (val += a + 256 << 16) : (val += a << 16);
        val = b < 0 ? (val += b + 256 << 8) : (val += b << 8);
        val = c < 0 ? (val += c + 256) : (val += c);
        return val;
    }

    public static int readReverseInt(ByteBuffer in) {
        byte a = in.get();
        byte b = in.get();
        byte c = in.get();
        byte d = in.get();
        int val = 0;
        val += d << 24;
        val += c << 16;
        val += b << 8;
        return val += a;
    }

    public static int readReverseIntOld(ByteBuffer in) {
        byte[] bytes = new byte[4];
        in.get(bytes);
        int val = 0;
        val += bytes[3] * 256 * 256 * 256;
        val += bytes[2] * 256 * 256;
        val += bytes[1] * 256;
        return val += bytes[0];
    }

    public static void encodeHeaderByte(ByteBuffer out, byte headerSize, int channelId) {
        if (channelId <= 63) {
            out.put((byte)((headerSize << 6) + channelId));
        } else if (channelId <= 320) {
            out.put((byte)(headerSize << 6));
            out.put((byte)(channelId - 64));
        } else {
            out.put((byte)(headerSize << 6 | 1));
            out.put((byte)((channelId -= 64) & 0xFF));
            out.put((byte)(channelId >> 8));
        }
    }

    public static int decodeChannelId(int header, int byteCount) {
        if (byteCount == 1) {
            return header & 0x3F;
        }
        if (byteCount == 2) {
            return 64 + (header & 0xFF);
        }
        return 64 + (header >> 8 & 0xFF) + ((header & 0xFF) << 8);
    }

    public static byte decodeHeaderSize(int header, int byteCount) {
        if (byteCount == 1) {
            return (byte)(header >> 6);
        }
        if (byteCount == 2) {
            return (byte)(header >> 14);
        }
        return (byte)(header >> 22);
    }

    public static int getHeaderLength(byte headerSize) {
        switch (headerSize) {
            case 0: {
                return 12;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }
}

