/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.codec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf3.Input;
import org.red5.io.object.Deserializer;
import org.red5.io.utils.BufferUtils;
import org.red5.server.api.IConnection;
import org.red5.server.api.IScope;
import org.red5.server.api.Red5;
import org.red5.server.net.protocol.HandshakeFailedException;
import org.red5.server.net.protocol.ProtocolException;
import org.red5.server.net.protocol.ProtocolState;
import org.red5.server.net.protocol.SimpleProtocolDecoder;
import org.red5.server.net.rtmp.RTMPUtils;
import org.red5.server.net.rtmp.codec.IEventDecoder;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.ClientBW;
import org.red5.server.net.rtmp.event.FlexMessage;
import org.red5.server.net.rtmp.event.FlexStreamSend;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.ServerBW;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmp.message.SharedObjectTypeMapping;
import org.red5.server.service.Call;
import org.red5.server.service.PendingCall;
import org.red5.server.so.FlexSharedObjectMessage;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.ISharedObjectMessage;
import org.red5.server.so.SharedObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPProtocolDecoder
implements Constants,
SimpleProtocolDecoder,
IEventDecoder {
    protected static Logger log = LoggerFactory.getLogger((String)RTMPProtocolDecoder.class.getName());
    protected static Logger ioLog = LoggerFactory.getLogger((String)(RTMPProtocolDecoder.class.getName() + ".in"));
    private Deserializer deserializer;

    public void setDeserializer(Deserializer deserializer) {
        this.deserializer = deserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List decodeBuffer(ProtocolState state, ByteBuffer buffer) {
        LinkedList<Object> result = new LinkedList<Object>();
        try {
            int remaining;
            while (state.canStartDecoding(remaining = buffer.remaining())) {
                state.startDecoding();
                Object decodedObject = this.decode(state, buffer);
                if (!state.hasDecodedObject()) {
                    if (state.canContinueDecoding()) {
                        continue;
                    }
                } else {
                    result.add(decodedObject);
                    if (buffer.hasRemaining()) continue;
                }
                break;
            }
        }
        catch (HandshakeFailedException hfe) {
            buffer.clear();
            IConnection conn = Red5.getConnectionLocal();
            if (conn != null) {
                conn.close();
            } else {
                log.error("Handshake validation failed but no current connection!?");
            }
            List list = null;
            return list;
        }
        catch (Exception ex) {
            log.error("Error decoding buffer", (Throwable)ex);
            buffer.clear();
            IConnection conn = Red5.getConnectionLocal();
            if (conn != null) {
                log.warn("Closing connection because decoding failed: " + conn.toString());
                conn.close();
            } else {
                log.error("Decoding buffer failed but no current connection!?");
            }
            List list = null;
            return list;
        }
        finally {
            buffer.compact();
        }
        return result;
    }

    protected void setupClassLoader() {
        IConnection conn = Red5.getConnectionLocal();
        if (conn == null) {
            return;
        }
        IScope scope = conn.getScope();
        if (scope != null) {
            Thread.currentThread().setContextClassLoader(scope.getClassLoader());
        }
    }

    public Object decode(ProtocolState state, ByteBuffer in) throws ProtocolException {
        int start = in.position();
        try {
            RTMP rtmp = (RTMP)state;
            switch (rtmp.getState()) {
                case 2: {
                    return this.decodePacket(rtmp, in);
                }
                case 3: {
                    return null;
                }
                case 0: 
                case 1: {
                    return this.decodeHandshake(rtmp, in);
                }
            }
            return null;
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (RuntimeException e) {
            throw new ProtocolException("Error during decoding", e);
        }
    }

    public ByteBuffer decodeHandshake(RTMP rtmp, ByteBuffer in) {
        int remaining = in.remaining();
        if (!rtmp.getMode()) {
            if (rtmp.getState() == 0) {
                if (remaining < 1537) {
                    if (log.isDebugEnabled()) {
                        log.debug("Handshake init too small, buffering. remaining: " + remaining);
                    }
                    rtmp.bufferDecoding(1537);
                    return null;
                }
                ByteBuffer hs = ByteBuffer.allocate((int)1536);
                in.get();
                BufferUtils.put(hs, in, 1536);
                hs.flip();
                rtmp.setState((byte)1);
                return hs;
            }
            if (rtmp.getState() == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("Handshake reply");
                }
                if (remaining < 1536) {
                    if (log.isDebugEnabled()) {
                        log.debug("Handshake reply too small, buffering. remaining: " + remaining);
                    }
                    rtmp.bufferDecoding(1536);
                    return null;
                }
                if (!rtmp.validateHandshakeReply(in, 8, 1528)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Handshake reply validation failed, disconnecting client.");
                    }
                    in.skip(1536);
                    rtmp.setState((byte)3);
                    throw new HandshakeFailedException("Handshake validation failed");
                }
                in.skip(1536);
                rtmp.setState((byte)2);
                rtmp.continueDecoding();
                return null;
            }
        } else if (rtmp.getState() == 0) {
            int size = 3073;
            if (remaining < 3073) {
                if (log.isDebugEnabled()) {
                    log.debug("Handshake init too small, buffering. remaining: " + remaining);
                }
                rtmp.bufferDecoding(3073);
                return null;
            }
            ByteBuffer hs = ByteBuffer.allocate((int)3073);
            BufferUtils.put(hs, in, 3073);
            hs.flip();
            rtmp.setState((byte)2);
            return hs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet decodePacket(RTMP rtmp, ByteBuffer in) {
        int readAmount;
        int byteCount;
        int headerValue;
        int remaining = in.remaining();
        if (remaining < 1) {
            rtmp.bufferDecoding(1);
            return null;
        }
        int position = in.position();
        byte headerByte = in.get();
        if ((headerByte & 0x3F) == 0) {
            if (remaining < 2) {
                in.position(position);
                rtmp.bufferDecoding(2);
                return null;
            }
            headerValue = (headerByte & 0xFF) << 8 | in.get() & 0xFF;
            byteCount = 2;
        } else if ((headerByte & 0x3F) == 1) {
            if (remaining < 3) {
                in.position(position);
                rtmp.bufferDecoding(3);
                return null;
            }
            headerValue = (headerByte & 0xFF) << 16 | (in.get() & 0xFF) << 8 | in.get() & 0xFF;
            byteCount = 3;
        } else {
            headerValue = headerByte & 0xFF;
            byteCount = 1;
        }
        int channelId = RTMPUtils.decodeChannelId(headerValue, byteCount);
        if (channelId < 0) {
            throw new ProtocolException("Bad channel id: " + channelId);
        }
        int headerLength = RTMPUtils.getHeaderLength(RTMPUtils.decodeHeaderSize(headerValue, byteCount));
        if ((headerLength += byteCount - 1) > remaining) {
            if (log.isDebugEnabled()) {
                log.debug("Header too small, buffering. remaining: " + remaining);
            }
            in.position(position);
            rtmp.bufferDecoding(headerLength);
            return null;
        }
        in.position(position);
        Header header = this.decodeHeader(in, rtmp.getLastReadHeader(channelId));
        if (header == null) {
            throw new ProtocolException("Header is null, check for error");
        }
        rtmp.setLastReadHeader(channelId, header);
        Packet packet = rtmp.getLastReadPacket(channelId);
        if (packet == null) {
            packet = new Packet(header);
            rtmp.setLastReadPacket(channelId, packet);
        }
        ByteBuffer buf = packet.getData();
        int addSize = header.getTimer() == 0xFFFFFF ? 4 : 0;
        int readRemaining = header.getSize() + addSize - buf.position();
        int chunkSize = rtmp.getReadChunkSize();
        int n = readAmount = readRemaining > chunkSize ? chunkSize : readRemaining;
        if (in.remaining() < readAmount) {
            if (log.isDebugEnabled()) {
                log.debug("Chunk too small, buffering (" + in.remaining() + ',' + readAmount);
            }
            in.position(position);
            rtmp.bufferDecoding(headerLength + readAmount);
            return null;
        }
        BufferUtils.put(buf, in, readAmount);
        if (buf.position() < header.getSize() + addSize) {
            rtmp.continueDecoding();
            return null;
        }
        if (log.isWarnEnabled() && buf.position() > header.getSize() + addSize) {
            log.warn("Packet size expanded from " + (header.getSize() + addSize) + " to " + buf.position() + " (" + header + ")");
        }
        buf.flip();
        try {
            IRTMPEvent message = this.decodeMessage(rtmp, packet.getHeader(), buf);
            packet.setMessage(message);
            if (message instanceof ChunkSize) {
                ChunkSize chunkSizeMsg = (ChunkSize)message;
                rtmp.setReadChunkSize(chunkSizeMsg.getSize());
            }
        }
        finally {
            rtmp.setLastReadPacket(channelId, null);
        }
        return packet;
    }

    public Header decodeHeader(ByteBuffer in, Header lastHeader) {
        int headerValue;
        byte headerByte = in.get();
        int byteCount = 1;
        if ((headerByte & 0x3F) == 0) {
            headerValue = (headerByte & 0xFF) << 8 | in.get() & 0xFF;
            byteCount = 2;
        } else if ((headerByte & 0x3F) == 1) {
            headerValue = (headerByte & 0xFF) << 16 | (in.get() & 0xFF) << 8 | in.get() & 0xFF;
            byteCount = 3;
        } else {
            headerValue = headerByte & 0xFF;
            byteCount = 1;
        }
        int channelId = RTMPUtils.decodeChannelId(headerValue, byteCount);
        byte headerSize = RTMPUtils.decodeHeaderSize(headerValue, byteCount);
        Header header = new Header();
        header.setChannelId(channelId);
        header.setTimerRelative(headerSize != 0);
        switch (headerSize) {
            case 0: {
                header.setTimer(RTMPUtils.readUnsignedMediumInt(in));
                header.setSize(RTMPUtils.readMediumInt(in));
                header.setDataType(in.get());
                header.setStreamId(RTMPUtils.readReverseInt(in));
                break;
            }
            case 1: {
                header.setTimer(RTMPUtils.readUnsignedMediumInt(in));
                header.setSize(RTMPUtils.readMediumInt(in));
                header.setDataType(in.get());
                header.setStreamId(lastHeader.getStreamId());
                break;
            }
            case 2: {
                header.setTimer(RTMPUtils.readUnsignedMediumInt(in));
                header.setSize(lastHeader.getSize());
                header.setDataType(lastHeader.getDataType());
                header.setStreamId(lastHeader.getStreamId());
                break;
            }
            case 3: {
                header.setTimer(lastHeader.getTimer());
                header.setSize(lastHeader.getSize());
                header.setDataType(lastHeader.getDataType());
                header.setStreamId(lastHeader.getStreamId());
                break;
            }
            default: {
                log.error("Unexpected header size: " + headerSize);
                return null;
            }
        }
        return header;
    }

    public IRTMPEvent decodeMessage(RTMP rtmp, Header header, ByteBuffer in) {
        IRTMPEvent message;
        if (header.getTimer() == 0xFFFFFF) {
            int unknown = in.getInt();
            if (log.isDebugEnabled()) {
                log.debug("Unknown 4 bytes: " + unknown);
            }
        }
        switch (header.getDataType()) {
            case 1: {
                message = this.decodeChunkSize(in);
                break;
            }
            case 20: {
                message = this.decodeInvoke(in, rtmp);
                break;
            }
            case 18: {
                if (header.getStreamId() == 0) {
                    message = this.decodeNotify(in, header, rtmp);
                    break;
                }
                message = this.decodeStreamMetadata(in);
                break;
            }
            case 4: {
                message = this.decodePing(in);
                break;
            }
            case 3: {
                message = this.decodeBytesRead(in);
                break;
            }
            case 8: {
                message = this.decodeAudioData(in);
                break;
            }
            case 9: {
                message = this.decodeVideoData(in);
                break;
            }
            case 16: {
                message = this.decodeFlexSharedObject(in, rtmp);
                break;
            }
            case 19: {
                message = this.decodeSharedObject(in, rtmp);
                break;
            }
            case 5: {
                message = this.decodeServerBW(in);
                break;
            }
            case 6: {
                message = this.decodeClientBW(in);
                break;
            }
            case 17: {
                message = this.decodeFlexMessage(in, rtmp);
                break;
            }
            case 15: {
                message = this.decodeFlexStreamSend(in);
                break;
            }
            default: {
                log.warn("Unknown object type: " + header.getDataType());
                message = this.decodeUnknown(header.getDataType(), in);
            }
        }
        message.setHeader(header);
        message.setTimestamp(header.getTimer());
        return message;
    }

    private IRTMPEvent decodeServerBW(ByteBuffer in) {
        return new ServerBW(in.getInt());
    }

    private IRTMPEvent decodeClientBW(ByteBuffer in) {
        return new ClientBW(in.getInt(), in.get());
    }

    public Unknown decodeUnknown(byte dataType, ByteBuffer in) {
        return new Unknown(dataType, in.asReadOnlyBuffer());
    }

    public ChunkSize decodeChunkSize(ByteBuffer in) {
        return new ChunkSize(in.getInt());
    }

    public ISharedObjectMessage decodeFlexSharedObject(ByteBuffer in, RTMP rtmp) {
        org.red5.io.amf.Input input;
        byte encoding = in.get();
        if (encoding == 0) {
            input = new org.red5.io.amf.Input(in);
        } else if (encoding == 3) {
            input = new Input(in);
        } else {
            throw new RuntimeException("Unknown SO encoding: " + encoding);
        }
        String name = input.getString();
        int version = in.getInt();
        boolean persistent = in.getInt() == 2;
        in.skip(4);
        FlexSharedObjectMessage so = new FlexSharedObjectMessage(null, name, version, persistent);
        this.doDecodeSharedObject(so, in, input);
        return so;
    }

    public ISharedObjectMessage decodeSharedObject(ByteBuffer in, RTMP rtmp) {
        org.red5.io.amf.Input input = new org.red5.io.amf.Input(in);
        String name = input.getString();
        int version = in.getInt();
        boolean persistent = in.getInt() == 2;
        in.skip(4);
        FlexSharedObjectMessage so = new FlexSharedObjectMessage(null, name, version, persistent);
        this.doDecodeSharedObject(so, in, input);
        return so;
    }

    protected void doDecodeSharedObject(SharedObjectMessage so, ByteBuffer in, org.red5.io.object.Input input) {
        this.setupClassLoader();
        Input amf3Input = new Input(in);
        while (in.hasRemaining()) {
            Object tmp;
            ISharedObjectEvent.Type type = SharedObjectTypeMapping.toType(in.get());
            if (type == null) {
                in.skip(in.remaining());
                return;
            }
            String key = null;
            Object value = null;
            int length = in.getInt();
            if (type == ISharedObjectEvent.Type.CLIENT_STATUS) {
                key = input.getString();
                value = input.getString();
            } else if (type == ISharedObjectEvent.Type.CLIENT_UPDATE_DATA) {
                key = null;
                HashMap<String, Object> map = new HashMap<String, Object>();
                int start = in.position();
                while (in.position() - start < length) {
                    tmp = input.getString();
                    map.put((String)tmp, this.deserializer.deserialize(input, Object.class));
                }
                value = map;
            } else if (type != ISharedObjectEvent.Type.SERVER_SEND_MESSAGE && type != ISharedObjectEvent.Type.CLIENT_SEND_MESSAGE) {
                if (length > 0 && length > (key = input.getString()).length() + 2) {
                    byte objType = in.get();
                    in.position(in.position() - 1);
                    org.red5.io.object.Input propertyInput = objType == 17 && !(input instanceof Input) ? amf3Input : input;
                    value = this.deserializer.deserialize(propertyInput, Object.class);
                }
            } else {
                int start = in.position();
                key = this.deserializer.deserialize(input, String.class);
                LinkedList<Object> list = new LinkedList<Object>();
                while (in.position() - start < length) {
                    tmp = this.deserializer.deserialize(input, Object.class);
                    list.add(tmp);
                }
                value = list;
            }
            so.addEvent(type, key, value);
        }
    }

    public Notify decodeNotify(ByteBuffer in, RTMP rtmp) {
        return this.decodeNotify(in, null, rtmp);
    }

    public Notify decodeNotify(ByteBuffer in, Header header, RTMP rtmp) {
        return this.decodeNotifyOrInvoke(new Notify(), in, header, rtmp);
    }

    public Invoke decodeInvoke(ByteBuffer in, RTMP rtmp) {
        return (Invoke)this.decodeNotifyOrInvoke(new Invoke(), in, null, rtmp);
    }

    private boolean isStreamCommand(String action) {
        return "createStream".equals(action) || "deleteStream".equals(action) || "publish".equals(action) || "play".equals(action) || "seek".equals(action) || "pause".equals(action) || "closeStream".equals(action) || "receiveVideo".equals(action) || "receiveAudio".equals(action);
    }

    protected Notify decodeNotifyOrInvoke(Notify notify, ByteBuffer in, Header header, RTMP rtmp) {
        String serviceMethod;
        int dotIndex;
        int start = in.position();
        org.red5.io.amf.Input input = rtmp.getEncoding() == IConnection.Encoding.AMF3 ? new Input(in) : new org.red5.io.amf.Input(in);
        String action = this.deserializer.deserialize(input, String.class);
        if (!(notify instanceof Invoke || rtmp == null || rtmp.getMode() || header == null || header.getStreamId() == 0 || this.isStreamCommand(action))) {
            in.position(start);
            notify.setData(in.asReadOnlyBuffer());
            return notify;
        }
        if (log.isDebugEnabled()) {
            log.debug("Action " + action);
        }
        if (header == null || header.getStreamId() == 0) {
            int invokeId = this.deserializer.deserialize(input, Number.class).intValue();
            notify.setInvokeId(invokeId);
        }
        Object[] params = new Object[]{};
        if (in.hasRemaining()) {
            this.setupClassLoader();
            ArrayList<Object> paramList = new ArrayList<Object>();
            Object obj = this.deserializer.deserialize(input, Object.class);
            if (obj instanceof Map) {
                Map connParams = (Map)obj;
                notify.setConnectionParams(connParams);
            } else if (obj != null) {
                paramList.add(obj);
            }
            while (in.hasRemaining()) {
                paramList.add(this.deserializer.deserialize(input, Object.class));
            }
            params = paramList.toArray();
            if (log.isDebugEnabled()) {
                log.debug("Num params: " + paramList.size());
                for (int i = 0; i < params.length; ++i) {
                    log.debug(" > " + i + ": " + params[i]);
                }
            }
        }
        String serviceName = (dotIndex = action.lastIndexOf(46)) == -1 ? null : action.substring(0, dotIndex);
        String string = serviceMethod = dotIndex == -1 ? action : action.substring(dotIndex + 1, action.length());
        if (notify instanceof Invoke) {
            PendingCall call = new PendingCall(serviceName, serviceMethod, params);
            ((Invoke)notify).setCall(call);
        } else {
            Call call = new Call(serviceName, serviceMethod, params);
            notify.setCall(call);
        }
        return notify;
    }

    public Ping decodePing(ByteBuffer in) {
        Ping ping = new Ping();
        ping.setDebug(in.getHexDump());
        ping.setValue1(in.getShort());
        ping.setValue2(in.getInt());
        if (in.hasRemaining()) {
            ping.setValue3(in.getInt());
        }
        if (in.hasRemaining()) {
            ping.setValue4(in.getInt());
        }
        return ping;
    }

    public BytesRead decodeBytesRead(ByteBuffer in) {
        return new BytesRead(in.getInt());
    }

    public AudioData decodeAudioData(ByteBuffer in) {
        return new AudioData(in.asReadOnlyBuffer());
    }

    public VideoData decodeVideoData(ByteBuffer in) {
        return new VideoData(in.asReadOnlyBuffer());
    }

    public Notify decodeStreamMetadata(ByteBuffer in) {
        return new Notify(in.asReadOnlyBuffer());
    }

    public FlexMessage decodeFlexMessage(ByteBuffer in, RTMP rtmp) {
        int dotIndex;
        in.skip(1);
        org.red5.io.amf.Input input = new org.red5.io.amf.Input(in);
        String action = this.deserializer.deserialize(input, String.class);
        int invokeId = this.deserializer.deserialize(input, Number.class).intValue();
        FlexMessage msg = new FlexMessage();
        msg.setInvokeId(invokeId);
        Object[] params = new Object[]{};
        if (in.hasRemaining()) {
            this.setupClassLoader();
            ArrayList<Object> paramList = new ArrayList<Object>();
            Object obj = this.deserializer.deserialize(input, Object.class);
            if (obj != null) {
                paramList.add(obj);
            }
            while (in.hasRemaining()) {
                byte tmp = in.get();
                in.position(in.position() - 1);
                input = tmp == 17 ? new Input(in) : new org.red5.io.amf.Input(in);
                paramList.add(this.deserializer.deserialize(input, Object.class));
            }
            params = paramList.toArray();
            if (log.isDebugEnabled()) {
                log.debug("Num params: " + paramList.size());
                for (int i = 0; i < params.length; ++i) {
                    log.debug(" > " + i + ": " + params[i]);
                }
            }
        }
        String serviceName = (dotIndex = action.lastIndexOf(46)) == -1 ? null : action.substring(0, dotIndex);
        String serviceMethod = dotIndex == -1 ? action : action.substring(dotIndex + 1, action.length());
        PendingCall call = new PendingCall(serviceName, serviceMethod, params);
        msg.setCall(call);
        return msg;
    }

    public FlexStreamSend decodeFlexStreamSend(ByteBuffer in) {
        return new FlexStreamSend(in.asReadOnlyBuffer());
    }
}

