/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.codec;

import java.util.List;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.amf3.Output;
import org.red5.io.object.Serializer;
import org.red5.io.utils.BufferUtils;
import org.red5.server.api.IConnection;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.net.protocol.BaseProtocolEncoder;
import org.red5.server.net.protocol.ProtocolState;
import org.red5.server.net.protocol.SimpleProtocolEncoder;
import org.red5.server.net.rtmp.RTMPUtils;
import org.red5.server.net.rtmp.codec.IEventEncoder;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.ClientBW;
import org.red5.server.net.rtmp.event.FlexMessage;
import org.red5.server.net.rtmp.event.FlexStreamSend;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.ServerBW;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmp.message.SharedObjectTypeMapping;
import org.red5.server.net.rtmp.status.StatusObject;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.ISharedObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPProtocolEncoder
extends BaseProtocolEncoder
implements SimpleProtocolEncoder,
Constants,
IEventEncoder {
    protected static Logger log = LoggerFactory.getLogger((String)RTMPProtocolEncoder.class.getName());
    protected static Logger ioLog = LoggerFactory.getLogger((String)(RTMPProtocolEncoder.class.getName() + ".out"));
    private Serializer serializer;

    public ByteBuffer encode(ProtocolState state, Object message) throws Exception {
        try {
            RTMP rtmp = (RTMP)state;
            if (message instanceof ByteBuffer) {
                return (ByteBuffer)message;
            }
            return this.encodePacket(rtmp, (Packet)message);
        }
        catch (RuntimeException e) {
            log.error("Error encoding object: ", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer encodePacket(RTMP rtmp, Packet packet) {
        ByteBuffer data;
        Header header = packet.getHeader();
        int channelId = header.getChannelId();
        IRTMPEvent message = packet.getMessage();
        if (message instanceof ChunkSize) {
            ChunkSize chunkSizeMsg = (ChunkSize)message;
            rtmp.setWriteChunkSize(chunkSizeMsg.getSize());
        }
        try {
            data = this.encodeMessage(rtmp, header, message);
        }
        finally {
            message.release();
        }
        if (data.position() != 0) {
            data.flip();
        } else {
            data.rewind();
        }
        header.setSize(data.limit());
        Header lastHeader = rtmp.getLastWriteHeader(channelId);
        int headerSize = this.calculateHeaderSize(header, lastHeader);
        rtmp.setLastWriteHeader(channelId, header);
        rtmp.setLastWritePacket(channelId, packet);
        int chunkSize = rtmp.getWriteChunkSize();
        int chunkHeaderSize = 1;
        if (header.getChannelId() > 320) {
            chunkHeaderSize = 3;
        } else if (header.getChannelId() > 63) {
            chunkHeaderSize = 2;
        }
        int numChunks = (int)Math.ceil((float)header.getSize() / (float)chunkSize);
        int bufSize = header.getSize() + headerSize + (numChunks > 0 ? (numChunks - 1) * chunkHeaderSize : 0);
        ByteBuffer out = ByteBuffer.allocate((int)bufSize, (boolean)false);
        this.encodeHeader(header, lastHeader, out);
        if (numChunks == 1) {
            BufferUtils.put(out, data, out.remaining());
        } else {
            for (int i = 0; i < numChunks - 1; ++i) {
                BufferUtils.put(out, data, chunkSize);
                RTMPUtils.encodeHeaderByte(out, (byte)3, header.getChannelId());
            }
            BufferUtils.put(out, data, out.remaining());
        }
        data.release();
        out.flip();
        data = null;
        return out;
    }

    private byte getHeaderType(Header header, Header lastHeader) {
        int headerType = lastHeader == null || header.getStreamId() != lastHeader.getStreamId() || !header.isTimerRelative() ? 0 : (header.getSize() != lastHeader.getSize() || header.getDataType() != lastHeader.getDataType() ? 1 : (header.getTimer() != lastHeader.getTimer() ? 2 : 3));
        return (byte)headerType;
    }

    private int calculateHeaderSize(Header header, Header lastHeader) {
        byte headerType = this.getHeaderType(header, lastHeader);
        int channelIdAdd = header.getChannelId() > 320 ? 2 : (header.getChannelId() > 63 ? 1 : 0);
        return RTMPUtils.getHeaderLength(headerType) + channelIdAdd;
    }

    public ByteBuffer encodeHeader(Header header, Header lastHeader) {
        ByteBuffer result = ByteBuffer.allocate((int)this.calculateHeaderSize(header, lastHeader));
        this.encodeHeader(header, lastHeader, result);
        return result;
    }

    public void encodeHeader(Header header, Header lastHeader, ByteBuffer buf) {
        byte headerType = this.getHeaderType(header, lastHeader);
        RTMPUtils.encodeHeaderByte(buf, headerType, header.getChannelId());
        switch (headerType) {
            case 0: {
                RTMPUtils.writeMediumInt(buf, header.getTimer());
                RTMPUtils.writeMediumInt(buf, header.getSize());
                buf.put(header.getDataType());
                RTMPUtils.writeReverseInt(buf, header.getStreamId());
                break;
            }
            case 1: {
                RTMPUtils.writeMediumInt(buf, header.getTimer());
                RTMPUtils.writeMediumInt(buf, header.getSize());
                buf.put(header.getDataType());
                break;
            }
            case 2: {
                RTMPUtils.writeMediumInt(buf, header.getTimer());
                break;
            }
            case 3: {
                break;
            }
        }
    }

    public ByteBuffer encodeMessage(RTMP rtmp, Header header, IRTMPEvent message) {
        switch (header.getDataType()) {
            case 1: {
                return this.encodeChunkSize((ChunkSize)message);
            }
            case 20: {
                return this.encodeInvoke((Invoke)message, rtmp);
            }
            case 18: {
                if (((Notify)message).getCall() == null) {
                    return this.encodeStreamMetadata((Notify)message);
                }
                return this.encodeNotify((Notify)message, rtmp);
            }
            case 4: {
                return this.encodePing((Ping)message);
            }
            case 3: {
                return this.encodeBytesRead((BytesRead)message);
            }
            case 8: {
                return this.encodeAudioData((AudioData)message);
            }
            case 9: {
                return this.encodeVideoData((VideoData)message);
            }
            case 16: {
                return this.encodeFlexSharedObject((ISharedObjectMessage)message, rtmp);
            }
            case 19: {
                return this.encodeSharedObject((ISharedObjectMessage)message, rtmp);
            }
            case 5: {
                return this.encodeServerBW((ServerBW)message);
            }
            case 6: {
                return this.encodeClientBW((ClientBW)message);
            }
            case 17: {
                return this.encodeFlexMessage((FlexMessage)message, rtmp);
            }
            case 15: {
                return this.encodeFlexStreamSend((FlexStreamSend)message);
            }
        }
        log.warn("Unknown object type: " + header.getDataType());
        return null;
    }

    private ByteBuffer encodeServerBW(ServerBW serverBW) {
        ByteBuffer out = ByteBuffer.allocate((int)4);
        out.putInt(serverBW.getBandwidth());
        return out;
    }

    private ByteBuffer encodeClientBW(ClientBW clientBW) {
        ByteBuffer out = ByteBuffer.allocate((int)5);
        out.putInt(clientBW.getBandwidth());
        out.put(clientBW.getValue2());
        return out;
    }

    public ByteBuffer encodeChunkSize(ChunkSize chunkSize) {
        ByteBuffer out = ByteBuffer.allocate((int)4);
        out.putInt(chunkSize.getSize());
        return out;
    }

    public ByteBuffer encodeFlexSharedObject(ISharedObjectMessage so, RTMP rtmp) {
        ByteBuffer out = ByteBuffer.allocate((int)128);
        out.setAutoExpand(true);
        out.put((byte)0);
        this.doEncodeSharedObject(so, rtmp, out);
        return out;
    }

    public ByteBuffer encodeSharedObject(ISharedObjectMessage so, RTMP rtmp) {
        ByteBuffer out = ByteBuffer.allocate((int)128);
        out.setAutoExpand(true);
        this.doEncodeSharedObject(so, rtmp, out);
        return out;
    }

    public void doEncodeSharedObject(ISharedObjectMessage so, RTMP rtmp, ByteBuffer out) {
        org.red5.io.amf.Output output = new org.red5.io.amf.Output(out);
        output.putString(so.getName());
        out.putInt(so.getVersion());
        out.putInt(so.isPersistent() ? 2 : 0);
        out.putInt(0);
        block7: for (ISharedObjectEvent event : so.getEvents()) {
            byte type = SharedObjectTypeMapping.toByte(event.getType());
            switch (event.getType()) {
                case SERVER_CONNECT: 
                case CLIENT_INITIAL_DATA: 
                case CLIENT_CLEAR_DATA: {
                    out.put(type);
                    out.putInt(0);
                    break;
                }
                case SERVER_DELETE_ATTRIBUTE: 
                case CLIENT_DELETE_DATA: 
                case CLIENT_UPDATE_ATTRIBUTE: {
                    out.put(type);
                    int mark = out.position();
                    out.skip(4);
                    output.putString(event.getKey());
                    int len = out.position() - mark - 4;
                    out.putInt(mark, len);
                    break;
                }
                case SERVER_SET_ATTRIBUTE: 
                case CLIENT_UPDATE_DATA: {
                    int len;
                    int mark;
                    if (event.getKey() == null) {
                        Map initialData = (Map)event.getValue();
                        for (Object o : initialData.keySet()) {
                            out.put(type);
                            mark = out.position();
                            out.skip(4);
                            String key = (String)o;
                            output.putString(key);
                            this.serializer.serialize(output, initialData.get(key));
                            len = out.position() - mark - 4;
                            out.putInt(mark, len);
                        }
                        continue block7;
                    }
                    out.put(type);
                    mark = out.position();
                    out.skip(4);
                    output.putString(event.getKey());
                    this.serializer.serialize(output, event.getValue());
                    len = out.position() - mark - 4;
                    out.putInt(mark, len);
                    break;
                }
                case CLIENT_SEND_MESSAGE: 
                case SERVER_SEND_MESSAGE: {
                    out.put(type);
                    int mark = out.position();
                    out.skip(4);
                    this.serializer.serialize(output, event.getKey());
                    for (Object arg : (List)event.getValue()) {
                        this.serializer.serialize(output, arg);
                    }
                    int len = out.position() - mark - 4;
                    out.putInt(mark, len);
                    break;
                }
                case CLIENT_STATUS: {
                    out.put(type);
                    String status = event.getKey();
                    String message = (String)event.getValue();
                    out.putInt(message.length() + status.length() + 4);
                    output.putString(message);
                    output.putString(status);
                    break;
                }
                default: {
                    out.put(type);
                    int mark = out.position();
                    out.skip(4);
                    output.putString(event.getKey());
                    this.serializer.serialize(output, event.getValue());
                    int len = out.position() - mark - 4;
                    out.putInt(mark, len);
                }
            }
        }
    }

    public ByteBuffer encodeNotify(Notify notify, RTMP rtmp) {
        return this.encodeNotifyOrInvoke(notify, rtmp);
    }

    public ByteBuffer encodeInvoke(Invoke invoke, RTMP rtmp) {
        return this.encodeNotifyOrInvoke(invoke, rtmp);
    }

    protected ByteBuffer encodeNotifyOrInvoke(Notify invoke, RTMP rtmp) {
        ByteBuffer out = ByteBuffer.allocate((int)1024);
        out.setAutoExpand(true);
        this.encodeNotifyOrInvoke(out, invoke, rtmp);
        return out;
    }

    protected void encodeNotifyOrInvoke(ByteBuffer out, Notify invoke, RTMP rtmp) {
        boolean isPending;
        org.red5.io.amf.Output output = new org.red5.io.amf.Output(out);
        IServiceCall call = invoke.getCall();
        boolean bl = isPending = call.getStatus() == 1;
        if (!isPending) {
            if (log.isDebugEnabled()) {
                log.debug("Call has been executed, send result");
            }
            this.serializer.serialize(output, call.isSuccess() ? "_result" : "_error");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("This is a pending call, send request");
            }
            String action = call.getServiceName() == null ? call.getServiceMethodName() : call.getServiceName() + '.' + call.getServiceMethodName();
            this.serializer.serialize(output, action);
        }
        if (invoke instanceof Invoke) {
            this.serializer.serialize(output, invoke.getInvokeId());
            this.serializer.serialize(output, invoke.getConnectionParams());
        }
        output = call.getServiceName() == null && "connect".equals(call.getServiceMethodName()) ? new org.red5.io.amf.Output(out) : (rtmp.getEncoding() == IConnection.Encoding.AMF3 ? new Output(out) : new org.red5.io.amf.Output(out));
        if (!isPending && invoke instanceof Invoke) {
            IPendingServiceCall pendingCall = (IPendingServiceCall)call;
            if (!call.isSuccess()) {
                StatusObject status = this.generateErrorResult("NetConnection.Call.Failed", call.getException());
                pendingCall.setResult(status);
            }
            if (log.isDebugEnabled()) {
                log.debug("Writing result: " + pendingCall.getResult());
            }
            this.serializer.serialize(output, pendingCall.getResult());
        } else {
            Object[] args;
            if (log.isDebugEnabled()) {
                log.debug("Writing params");
            }
            if ((args = invoke.getCall().getArguments()) != null) {
                for (Object element : args) {
                    this.serializer.serialize(output, element);
                }
            }
        }
    }

    public ByteBuffer encodePing(Ping ping) {
        int len = 6;
        if (ping.getValue3() != -1) {
            len += 4;
        }
        if (ping.getValue4() != -1) {
            len += 4;
        }
        ByteBuffer out = ByteBuffer.allocate((int)len);
        out.putShort(ping.getValue1());
        out.putInt(ping.getValue2());
        if (ping.getValue3() != -1) {
            out.putInt(ping.getValue3());
        }
        if (ping.getValue4() != -1) {
            out.putInt(ping.getValue4());
        }
        return out;
    }

    public ByteBuffer encodeBytesRead(BytesRead bytesRead) {
        ByteBuffer out = ByteBuffer.allocate((int)4);
        out.putInt(bytesRead.getBytesRead());
        return out;
    }

    public ByteBuffer encodeAudioData(AudioData audioData) {
        ByteBuffer result = audioData.getData();
        result.acquire();
        return result;
    }

    public ByteBuffer encodeVideoData(VideoData videoData) {
        ByteBuffer result = videoData.getData();
        result.acquire();
        return result;
    }

    public ByteBuffer encodeUnknown(Unknown unknown) {
        ByteBuffer result = unknown.getData();
        result.acquire();
        return result;
    }

    public ByteBuffer encodeStreamMetadata(Notify metaData) {
        ByteBuffer result = metaData.getData();
        result.acquire();
        return result;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public ByteBuffer encodeFlexMessage(FlexMessage msg, RTMP rtmp) {
        ByteBuffer out = ByteBuffer.allocate((int)1024);
        out.setAutoExpand(true);
        out.put((byte)0);
        this.encodeNotifyOrInvoke(out, msg, rtmp);
        return out;
    }

    public ByteBuffer encodeFlexStreamSend(FlexStreamSend msg) {
        ByteBuffer result = msg.getData();
        result.acquire();
        return result;
    }
}

