/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.util.HashMap;
import java.util.Map;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationDebugger {
    private static AllocationDebugger instance;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<BaseEvent, Info> events = new HashMap<BaseEvent, Info>();

    public static AllocationDebugger getInstance() {
        if (instance == null) {
            instance = new AllocationDebugger();
        }
        return instance;
    }

    private AllocationDebugger() {
    }

    protected synchronized void create(BaseEvent event) {
        this.events.put(event, new Info());
    }

    protected synchronized void retain(BaseEvent event) {
        Info info = this.events.get(event);
        if (info != null) {
            ++info.refcount;
        } else {
            this.log.warn("Retain called on already released event.");
        }
    }

    protected synchronized void release(BaseEvent event) {
        Info info = this.events.get(event);
        if (info != null) {
            --info.refcount;
            if (info.refcount == 0) {
                this.events.remove(event);
            }
        } else {
            this.log.warn("Release called on already released event.");
        }
    }

    public synchronized void dump() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("dumping allocations " + this.events.size());
            for (Map.Entry<BaseEvent, Info> entry : this.events.entrySet()) {
                this.log.debug(entry.getKey() + " " + entry.getValue().refcount);
            }
        }
    }

    private class Info {
        public int refcount = 1;
    }
}

