/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.SerializeUtils;
import org.red5.server.stream.IStreamData;

public class AudioData
extends BaseEvent
implements IStreamData,
IStreamPacket {
    private static final long serialVersionUID = -4102940670913999407L;
    protected ByteBuffer data;

    public AudioData() {
        this(ByteBuffer.allocate((int)0).flip());
    }

    public AudioData(ByteBuffer data) {
        super(IEvent.Type.STREAM_DATA);
        this.data = data;
    }

    public byte getDataType() {
        return 8;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public String toString() {
        return "Audio  ts: " + this.getTimestamp();
    }

    protected void releaseInternal() {
        if (this.data != null) {
            this.data.release();
            this.data = null;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte[] byteBuf = (byte[])in.readObject();
        if (byteBuf != null) {
            this.data = ByteBuffer.allocate((int)0);
            this.data.setAutoExpand(true);
            SerializeUtils.ByteArrayToByteBuffer(byteBuf, this.data);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.data != null) {
            out.writeObject(SerializeUtils.ByteBufferToByteArray(this.data));
        } else {
            out.writeObject(null);
        }
    }
}

