/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.SerializeUtils;
import org.red5.server.stream.IStreamData;

public class Notify
extends BaseEvent
implements IStreamData,
IStreamPacket {
    private static final long serialVersionUID = -6085848257275156569L;
    protected IServiceCall call;
    protected ByteBuffer data;
    private int invokeId = 0;
    private Map connectionParams;

    public Notify() {
        super(IEvent.Type.SERVICE_CALL);
    }

    public Notify(ByteBuffer data) {
        super(IEvent.Type.STREAM_DATA);
        this.data = data;
    }

    public Notify(IServiceCall call) {
        super(IEvent.Type.SERVICE_CALL);
        this.call = call;
    }

    public byte getDataType() {
        return 18;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public void setCall(IServiceCall call) {
        this.call = call;
    }

    public IServiceCall getCall() {
        return this.call;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getInvokeId() {
        return this.invokeId;
    }

    public void setInvokeId(int invokeId) {
        this.invokeId = invokeId;
    }

    protected void doRelease() {
        this.call = null;
    }

    public Map getConnectionParams() {
        return this.connectionParams;
    }

    public void setConnectionParams(Map connectionParams) {
        this.connectionParams = connectionParams;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Notify: ").append(this.call);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notify)) {
            return false;
        }
        Notify other = (Notify)obj;
        if (this.getConnectionParams() == null && other.getConnectionParams() != null) {
            return false;
        }
        if (this.getConnectionParams() != null && other.getConnectionParams() == null) {
            return false;
        }
        if (this.getConnectionParams() != null && !((Object)this.getConnectionParams()).equals(other.getConnectionParams())) {
            return false;
        }
        if (this.getInvokeId() != other.getInvokeId()) {
            return false;
        }
        if (this.getCall() == null && other.getCall() != null) {
            return false;
        }
        if (this.getCall() != null && other.getCall() == null) {
            return false;
        }
        return this.getCall() == null || this.getCall().equals(other.getCall());
    }

    protected void releaseInternal() {
        if (this.data != null) {
            this.data = null;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.call = (IServiceCall)in.readObject();
        this.connectionParams = (Map)in.readObject();
        this.invokeId = in.readInt();
        byte[] byteBuf = (byte[])in.readObject();
        if (byteBuf != null) {
            this.data = ByteBuffer.allocate((int)0);
            this.data.setAutoExpand(true);
            SerializeUtils.ByteArrayToByteBuffer(byteBuf, this.data);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.call);
        out.writeObject(this.connectionParams);
        out.writeInt(this.invokeId);
        if (this.data != null) {
            out.writeObject(SerializeUtils.ByteBufferToByteArray(this.data));
        } else {
            out.writeObject(null);
        }
    }
}

