/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.utils.HexDump;
import org.red5.server.api.event.IEvent;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.SerializeUtils;

public class Unknown
extends BaseEvent {
    private static final long serialVersionUID = -1352770037962252975L;
    protected ByteBuffer data;
    protected byte dataType;

    public Unknown() {
    }

    public Unknown(byte dataType, ByteBuffer data) {
        super(IEvent.Type.SYSTEM);
        this.dataType = dataType;
        this.data = data;
    }

    public byte getDataType() {
        return this.dataType;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public String toString() {
        ByteBuffer buf = this.getData();
        StringBuffer sb = new StringBuffer();
        sb.append("Size: " + buf.remaining());
        sb.append("Data:\n\n" + HexDump.formatHexDump(buf.getHexDump()));
        return sb.toString();
    }

    protected void releaseInternal() {
        if (this.data != null) {
            this.data.release();
            this.data = null;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.dataType = in.readByte();
        byte[] byteBuf = (byte[])in.readObject();
        if (byteBuf != null) {
            this.data = ByteBuffer.allocate((int)0);
            this.data.setAutoExpand(true);
            SerializeUtils.ByteArrayToByteBuffer(byteBuf, this.data);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(this.dataType);
        if (this.data != null) {
            out.writeObject(SerializeUtils.ByteBufferToByteArray(this.data));
        } else {
            out.writeObject(null);
        }
    }
}

