/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.mina.common.ByteBuffer;
import org.red5.io.IoConstants;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.SerializeUtils;
import org.red5.server.stream.IStreamData;

public class VideoData
extends BaseEvent
implements IoConstants,
IStreamData,
IStreamPacket {
    private static final long serialVersionUID = 5538859593815804830L;
    protected ByteBuffer data;
    private FrameType frameType = FrameType.UNKNOWN;

    public VideoData() {
        this(ByteBuffer.allocate((int)0).flip());
    }

    public VideoData(ByteBuffer data) {
        super(IEvent.Type.STREAM_DATA);
        this.data = data;
        if (data != null && data.limit() > 0) {
            int oldPos = data.position();
            int firstByte = data.get() & 0xFF;
            data.position(oldPos);
            int frameType = (firstByte & 0xFFFFFFF1) >> 4;
            this.frameType = frameType == 1 ? FrameType.KEYFRAME : (frameType == 2 ? FrameType.INTERFRAME : (frameType == 3 ? FrameType.DISPOSABLE_INTERFRAME : FrameType.UNKNOWN));
        }
    }

    public byte getDataType() {
        return 9;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public String toString() {
        return "Video  ts: " + this.getTimestamp();
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    protected void releaseInternal() {
        if (this.data != null) {
            this.data.release();
            this.data = null;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.frameType = (FrameType)((Object)in.readObject());
        byte[] byteBuf = (byte[])in.readObject();
        if (byteBuf != null) {
            this.data = ByteBuffer.allocate((int)0);
            this.data.setAutoExpand(true);
            SerializeUtils.ByteArrayToByteBuffer(byteBuf, this.data);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject((Object)this.frameType);
        if (this.data != null) {
            out.writeObject(SerializeUtils.ByteBufferToByteArray(this.data));
        } else {
            out.writeObject(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrameType {
        UNKNOWN,
        KEYFRAME,
        INTERFRAME,
        DISPOSABLE_INTERFRAME;

    }
}

