/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.mina.common.ByteBuffer;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.message.Header;

public class Packet
implements Externalizable {
    private static final long serialVersionUID = -6415050845346626950L;
    protected Header header;
    protected IRTMPEvent message;
    protected ByteBuffer data;

    public Packet() {
        this.data = null;
    }

    public Packet(Header header) {
        this.header = header;
        this.data = ByteBuffer.allocate((int)(header.getSize() + (header.getTimer() == 0xFFFFFF ? 4 : 0)), (boolean)false);
        this.data.setAutoExpand(true);
    }

    public Packet(Header header, IRTMPEvent event) {
        this.header = header;
        this.message = event;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setMessage(IRTMPEvent message) {
        this.message = message;
    }

    public IRTMPEvent getMessage() {
        return this.message;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.header = (Header)in.readObject();
        this.message = (IRTMPEvent)in.readObject();
        this.message.setHeader(this.header);
        this.message.setTimestamp(this.header.getTimer());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.header);
        out.writeObject(this.message);
    }
}

